/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.AbstractCICSObjectContainer;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ObjectGetter<T extends ICICSObject>
implements AbstractCICSObjectContainer.IObjectGetter<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICPSM cpsm;
    private final IContext context;
    private final ICICSType<T> type;
    private String stub;
    private int size;

    public ObjectGetter(ICPSM cpsm, ICICSType<T> type, IContext context) {
        this.cpsm = cpsm;
        this.type = type;
        this.context = context;
    }

    @Override
    public ICICSType<T> getCICSType() {
        return this.type;
    }

    @Override
    public int get() throws CICSActionException {
        SMConnectionResponse response = this.cpsm.get(this.type.getResourceTableName(), this.context);
        this.stub = response.getStub();
        this.size = response.getRecordTotal();
        return response.getRecordTotal();
    }

    @Override
    public List<T> fetch(int start, int count) throws CICSActionException {
        if (this.stub == null) {
            throw new IllegalStateException("'get()' must be invoked before results can be fetched");
        }
        SMConnectionResponse response = this.cpsm.fetch(this.stub, start + 1, count);
        ArrayList<T> resources = new ArrayList<T>();
        int i = 0;
        while (i < response.getRecordCount()) {
            T resource = ObjectGetter.createResource(this.cpsm, response.getRecord(i), this.type);
            resources.add(resource);
            ++i;
        }
        return resources;
    }

    private static <X extends ICICSObject> X createResource(ICPSM cpsm, SMConnectionRecord record, ICICSType<X> type) {
        X object = null;
        if (record != null) {
            object = CICSCore.create(cpsm, record, type);
        }
        return object;
    }

    @Override
    public void discard() throws CICSActionException {
        if (this.stub == null) {
            throw new IllegalStateException("'get()' must be invoked before discard");
        }
        this.cpsm.discard2(this.stub);
        this.stub = null;
        this.size = 0;
    }

    @Override
    public List<T> getAll() throws CICSActionException {
        if (this.stub != null) {
            return this.fetch(0, this.size);
        }
        return new ArrayList<ICICSObject>(Arrays.asList(this.cpsm.getDefinitions2(this.type, this.context)));
    }
}

