/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TaskRelatedUserExitReference;
import com.ibm.cics.core.model.TaskRelatedUserExitType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.ITaskRelatedUserExit;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class TaskRelatedUserExit
extends CICSResource
implements ITaskRelatedUserExit {
    private String _program;
    private String _entryname;
    private String _gaentryname;
    private ITaskRelatedUserExit.FormatEDFStatusValue _formatedfst;
    private ITaskRelatedUserExit.ShutdownStatusValue _shutdownst;
    private ITaskRelatedUserExit.StartStatusValue _startstatus;
    private ITaskRelatedUserExit.TaskStartStatusValue _taskstart;
    private Long _gausecount;
    private Long _galength;
    private Long _talength;
    private String _entry;
    private ITaskRelatedUserExit.ConnectStatusValue _connectst;
    private ITaskRelatedUserExit.INDOUBTWAITStatusValue _indoubtst;
    private String _qualifier;
    private ITaskRelatedUserExit.SPICallEnablementValue _spist;
    private ITaskRelatedUserExit.ConcurrencyTypeValue _concurrentst;
    private ITaskRelatedUserExit.OpenAPIStatusValue _apist;
    private ITaskRelatedUserExit.PurgeableStatusValue _purgeablest;

    public TaskRelatedUserExit(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._program = (String)avm.getAttributeValue(TaskRelatedUserExitType.PROGRAM_NAME);
        this._entryname = (String)avm.getAttributeValue(TaskRelatedUserExitType.ENTRY_NAME);
        this._gaentryname = (String)avm.getAttributeValue(TaskRelatedUserExitType.GA_ENTRY_NAME, true);
        this._formatedfst = (ITaskRelatedUserExit.FormatEDFStatusValue)avm.getAttributeValue(TaskRelatedUserExitType.FORMAT_EDF_STATUS, true);
        this._shutdownst = (ITaskRelatedUserExit.ShutdownStatusValue)avm.getAttributeValue(TaskRelatedUserExitType.SHUTDOWN_STATUS, true);
        this._startstatus = (ITaskRelatedUserExit.StartStatusValue)avm.getAttributeValue(TaskRelatedUserExitType.START_STATUS, true);
        this._taskstart = (ITaskRelatedUserExit.TaskStartStatusValue)avm.getAttributeValue(TaskRelatedUserExitType.TASK_START_STATUS, true);
        this._gausecount = (Long)avm.getAttributeValue(TaskRelatedUserExitType.GA_USER_COUNT, true);
        this._galength = (Long)avm.getAttributeValue(TaskRelatedUserExitType.GA_LENGTH, true);
        this._talength = (Long)avm.getAttributeValue(TaskRelatedUserExitType.LOCAL_WORK_AREA_LENGTH, true);
        this._entry = (String)avm.getAttributeValue(TaskRelatedUserExitType.ENTRY, true);
        this._connectst = (ITaskRelatedUserExit.ConnectStatusValue)avm.getAttributeValue(TaskRelatedUserExitType.CONNECT_STATUS, true);
        this._indoubtst = (ITaskRelatedUserExit.INDOUBTWAITStatusValue)avm.getAttributeValue(TaskRelatedUserExitType.INDOUBTWAIT_STATUS, true);
        this._qualifier = (String)avm.getAttributeValue(TaskRelatedUserExitType.SPI_QUALIFIER, true);
        this._spist = (ITaskRelatedUserExit.SPICallEnablementValue)avm.getAttributeValue(TaskRelatedUserExitType.SPI_CALL_ENABLEMENT, true);
        this._concurrentst = (ITaskRelatedUserExit.ConcurrencyTypeValue)avm.getAttributeValue(TaskRelatedUserExitType.CONCURRENCY_TYPE, true);
        this._apist = (ITaskRelatedUserExit.OpenAPIStatusValue)avm.getAttributeValue(TaskRelatedUserExitType.OPEN_API_STATUS, true);
        this._purgeablest = (ITaskRelatedUserExit.PurgeableStatusValue)avm.getAttributeValue(TaskRelatedUserExitType.PURGEABLE_STATUS, true);
    }

    public TaskRelatedUserExit(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("PROGRAM");
        this._program = (String)((CICSAttribute)TaskRelatedUserExitType.PROGRAM_NAME).get(stringValue, normalizers);
        stringValue = record.get("ENTRYNAME");
        this._entryname = (String)((CICSAttribute)TaskRelatedUserExitType.ENTRY_NAME).get(stringValue, normalizers);
        stringValue = record.get("GAENTRYNAME");
        this._gaentryname = (String)((CICSAttribute)TaskRelatedUserExitType.GA_ENTRY_NAME).get(stringValue, normalizers);
        stringValue = record.get("FORMATEDFST");
        this._formatedfst = (ITaskRelatedUserExit.FormatEDFStatusValue)((CICSAttribute)TaskRelatedUserExitType.FORMAT_EDF_STATUS).get(stringValue, normalizers);
        stringValue = record.get("SHUTDOWNST");
        this._shutdownst = (ITaskRelatedUserExit.ShutdownStatusValue)((CICSAttribute)TaskRelatedUserExitType.SHUTDOWN_STATUS).get(stringValue, normalizers);
        stringValue = record.get("STARTSTATUS");
        this._startstatus = (ITaskRelatedUserExit.StartStatusValue)((CICSAttribute)TaskRelatedUserExitType.START_STATUS).get(stringValue, normalizers);
        stringValue = record.get("TASKSTART");
        this._taskstart = (ITaskRelatedUserExit.TaskStartStatusValue)((CICSAttribute)TaskRelatedUserExitType.TASK_START_STATUS).get(stringValue, normalizers);
        stringValue = record.get("GAUSECOUNT");
        this._gausecount = (Long)((CICSAttribute)TaskRelatedUserExitType.GA_USER_COUNT).get(stringValue, normalizers);
        stringValue = record.get("GALENGTH");
        this._galength = (Long)((CICSAttribute)TaskRelatedUserExitType.GA_LENGTH).get(stringValue, normalizers);
        stringValue = record.get("TALENGTH");
        this._talength = (Long)((CICSAttribute)TaskRelatedUserExitType.LOCAL_WORK_AREA_LENGTH).get(stringValue, normalizers);
        stringValue = record.get("ENTRY");
        this._entry = (String)((CICSAttribute)TaskRelatedUserExitType.ENTRY).get(stringValue, normalizers);
        stringValue = record.get("CONNECTST");
        this._connectst = (ITaskRelatedUserExit.ConnectStatusValue)((CICSAttribute)TaskRelatedUserExitType.CONNECT_STATUS).get(stringValue, normalizers);
        stringValue = record.get("INDOUBTST");
        this._indoubtst = (ITaskRelatedUserExit.INDOUBTWAITStatusValue)((CICSAttribute)TaskRelatedUserExitType.INDOUBTWAIT_STATUS).get(stringValue, normalizers);
        stringValue = record.get("QUALIFIER");
        this._qualifier = (String)((CICSAttribute)TaskRelatedUserExitType.SPI_QUALIFIER).get(stringValue, normalizers);
        stringValue = record.get("SPIST");
        this._spist = (ITaskRelatedUserExit.SPICallEnablementValue)((CICSAttribute)TaskRelatedUserExitType.SPI_CALL_ENABLEMENT).get(stringValue, normalizers);
        stringValue = record.get("CONCURRENTST");
        this._concurrentst = (ITaskRelatedUserExit.ConcurrencyTypeValue)((CICSAttribute)TaskRelatedUserExitType.CONCURRENCY_TYPE).get(stringValue, normalizers);
        stringValue = record.get("APIST");
        this._apist = (ITaskRelatedUserExit.OpenAPIStatusValue)((CICSAttribute)TaskRelatedUserExitType.OPEN_API_STATUS).get(stringValue, normalizers);
        stringValue = record.get("PURGEABLEST");
        this._purgeablest = (ITaskRelatedUserExit.PurgeableStatusValue)((CICSAttribute)TaskRelatedUserExitType.PURGEABLE_STATUS).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return TaskRelatedUserExitType.PROGRAM_NAME.internalToExternal((Object)this.getProgramName());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getProgramName() {
        return this._program;
    }

    public String getEntryName() {
        return this._entryname;
    }

    public String getGAEntryName() {
        return this._gaentryname;
    }

    public ITaskRelatedUserExit.FormatEDFStatusValue getFormatEDFStatus() {
        return this._formatedfst;
    }

    public ITaskRelatedUserExit.ShutdownStatusValue getShutdownStatus() {
        return this._shutdownst;
    }

    public ITaskRelatedUserExit.StartStatusValue getStartStatus() {
        return this._startstatus;
    }

    public ITaskRelatedUserExit.TaskStartStatusValue getTaskStartStatus() {
        return this._taskstart;
    }

    public Long getGAUserCount() {
        return this._gausecount;
    }

    public Long getGALength() {
        return this._galength;
    }

    public Long getLocalWorkAreaLength() {
        return this._talength;
    }

    public String getEntry() {
        return this._entry;
    }

    public ITaskRelatedUserExit.ConnectStatusValue getConnectStatus() {
        return this._connectst;
    }

    public ITaskRelatedUserExit.INDOUBTWAITStatusValue getINDOUBTWAITStatus() {
        return this._indoubtst;
    }

    public String getSPIQualifier() {
        return this._qualifier;
    }

    public ITaskRelatedUserExit.SPICallEnablementValue getSPICallEnablement() {
        return this._spist;
    }

    public ITaskRelatedUserExit.ConcurrencyTypeValue getConcurrencyType() {
        return this._concurrentst;
    }

    public ITaskRelatedUserExit.OpenAPIStatusValue getOpenAPIStatus() {
        return this._apist;
    }

    public ITaskRelatedUserExit.PurgeableStatusValue getPurgeableStatus() {
        return this._purgeablest;
    }

    public TaskRelatedUserExitType getObjectType() {
        return TaskRelatedUserExitType.getInstance();
    }

    @Override
    public TaskRelatedUserExitReference getCICSObjectReference() {
        return new TaskRelatedUserExitReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TaskRelatedUserExitType.PROGRAM_NAME) {
            return (V)this.getProgramName();
        }
        if (attribute == TaskRelatedUserExitType.ENTRY_NAME) {
            return (V)this.getEntryName();
        }
        if (attribute == TaskRelatedUserExitType.GA_ENTRY_NAME) {
            return (V)this.getGAEntryName();
        }
        if (attribute == TaskRelatedUserExitType.FORMAT_EDF_STATUS) {
            return (V)this.getFormatEDFStatus();
        }
        if (attribute == TaskRelatedUserExitType.SHUTDOWN_STATUS) {
            return (V)this.getShutdownStatus();
        }
        if (attribute == TaskRelatedUserExitType.START_STATUS) {
            return (V)this.getStartStatus();
        }
        if (attribute == TaskRelatedUserExitType.TASK_START_STATUS) {
            return (V)this.getTaskStartStatus();
        }
        if (attribute == TaskRelatedUserExitType.GA_USER_COUNT) {
            return (V)this.getGAUserCount();
        }
        if (attribute == TaskRelatedUserExitType.GA_LENGTH) {
            return (V)this.getGALength();
        }
        if (attribute == TaskRelatedUserExitType.LOCAL_WORK_AREA_LENGTH) {
            return (V)this.getLocalWorkAreaLength();
        }
        if (attribute == TaskRelatedUserExitType.ENTRY) {
            return (V)this.getEntry();
        }
        if (attribute == TaskRelatedUserExitType.CONNECT_STATUS) {
            return (V)this.getConnectStatus();
        }
        if (attribute == TaskRelatedUserExitType.INDOUBTWAIT_STATUS) {
            return (V)this.getINDOUBTWAITStatus();
        }
        if (attribute == TaskRelatedUserExitType.SPI_QUALIFIER) {
            return (V)this.getSPIQualifier();
        }
        if (attribute == TaskRelatedUserExitType.SPI_CALL_ENABLEMENT) {
            return (V)this.getSPICallEnablement();
        }
        if (attribute == TaskRelatedUserExitType.CONCURRENCY_TYPE) {
            return (V)this.getConcurrencyType();
        }
        if (attribute == TaskRelatedUserExitType.OPEN_API_STATUS) {
            return (V)this.getOpenAPIStatus();
        }
        if (attribute == TaskRelatedUserExitType.PURGEABLE_STATUS) {
            return (V)this.getPurgeableStatus();
        }
        return super.getAttributeValue(attribute);
    }
}

