/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadGroupReference;
import com.ibm.cics.core.model.WorkloadGroupType;
import com.ibm.cics.core.model.internal.CPSMDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IWorkloadDefinitionInWorkloadGroup;
import com.ibm.cics.model.IWorkloadGroup;
import com.ibm.cics.model.IWorkloadGroupInWorkloadSpecification;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class WorkloadGroup
extends CPSMDefinition
implements IWorkloadGroup {
    private String _name;
    private String _desc;

    public WorkloadGroup(ICPSMDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._name = (String)avm.getAttributeValue(WorkloadGroupType.NAME);
        this._desc = (String)avm.getAttributeValue(WorkloadGroupType.DESCRIPTION, true);
    }

    public WorkloadGroup(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)WorkloadGroupType.NAME).get(stringValue, normalizers);
        stringValue = record.get("DESC");
        this._desc = (String)((CICSAttribute)WorkloadGroupType.DESCRIPTION).get(stringValue, normalizers);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._desc;
    }

    public WorkloadGroupType getObjectType() {
        return WorkloadGroupType.getInstance();
    }

    @Override
    public WorkloadGroupReference getCICSObjectReference() {
        return new WorkloadGroupReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadGroupType.NAME) {
            return (V)this.getName();
        }
        if (attribute == WorkloadGroupType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        return super.getAttributeValue(attribute);
    }

    public ICICSObjectSet<IWorkloadDefinitionInWorkloadGroup> getDefinitionMembers() {
        return WorkloadGroupType.DEFINITION_MEMBERS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IWorkloadGroupInWorkloadSpecification> getSpecMemberships() {
        return WorkloadGroupType.SPEC_MEMBERSHIPS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

