/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMManager;
import com.ibm.cics.model.query.CICSObjectRecordsQueryResult;
import com.ibm.cics.model.query.CICSResourcesQuery;
import com.ibm.cics.model.query.CICSplexQuery;
import com.ibm.cics.model.query.CICSplexQueryResult;
import com.ibm.cics.model.query.CPSMManagersQuery;
import com.ibm.cics.model.query.DREPQuery;
import com.ibm.cics.model.query.DREPQueryResult;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.model.query.RegionGroupQuery;
import com.ibm.cics.model.query.RegionGroupQueryResult;
import com.ibm.cics.model.query.RegionQuery;
import com.ibm.cics.model.query.RegionQueryResult;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.query.AggregationMeta;
import com.ibm.cics.sm.comm.sm.internal.query.CICSResourcesQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CPSMManagersQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.DREPQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.RegionGroupQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.RegionQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.ResourceQueryNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

class CICSplexQueryImpl
extends ResourceQueryNode<CICSplexQueryResult>
implements CICSplexQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String REGION = "region";
    private static final String REGIONS = "regions";
    private static final String REGION_GROUP = "regionGroup";
    private static final String REGION_GROUPS = "regionGroups";
    private static final String DREP = "drep";
    private static final String NAME = "name";
    private static final String GRAPHQL_TYPE_NAME = "CICSplexType";
    private NodeParser<String> nameParser;
    private NodeParser<Optional<List<RegionQueryResult>>> regionsParser;
    private NodeParser<Optional<List<RegionGroupQueryResult>>> regionGroupsParser;
    private NodeParser<Optional<RegionQueryResult>> regionParser;
    private NodeParser<Optional<RegionGroupQueryResult>> regionGroupParser;
    private NodeParser<DREPQueryResult> drepParser;
    private NodeParser<Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult>> cicsResourcesParser;
    private NodeParser<Map<ICICSType<? extends ICPSMManager>, CICSObjectRecordsQueryResult>> cpsmManagersParser;
    private final DREPQueryImpl drepQueryImpl;
    private final RegionQueryImpl regionQueryImpl;
    private final RegionGroupQueryImpl regionGroupQueryImpl;

    public CICSplexQueryImpl(Map<ICICSType<?>, AggregationMeta> aggregationMeta) {
        super(GRAPHQL_TYPE_NAME, aggregationMeta);
        this.drepQueryImpl = new DREPQueryImpl(aggregationMeta);
        this.regionQueryImpl = new RegionQueryImpl(aggregationMeta);
        this.regionGroupQueryImpl = new RegionGroupQueryImpl(aggregationMeta);
    }

    public CICSplexQueryImpl name() {
        this.nameParser = NodeParser.nonNull(this.stringField(NAME));
        return this;
    }

    public CICSplexQueryImpl regions(Consumer<RegionQuery> query) {
        this.regionsParser = this.arrayFieldNonNullValues(REGIONS, this.regionQueryImpl, query);
        return this;
    }

    public CICSplexQueryImpl regionGroups(Consumer<RegionGroupQuery> query) {
        this.regionGroupsParser = this.arrayFieldNonNullValues(REGION_GROUPS, this.regionGroupQueryImpl, query);
        return this;
    }

    public CICSplexQueryImpl drep(Consumer<DREPQuery> query) {
        this.drepParser = NodeParser.nonNull(this.objectField(DREP, this.drepQueryImpl, query));
        return this;
    }

    public CICSplexQueryImpl region(String name, Consumer<RegionQuery> query) {
        this.regionParser = this.objectField(REGION, ac -> {
            ArgumentsContext argumentsContext = ac.argString(NAME, name);
        }, this.regionQueryImpl, query);
        return this;
    }

    public CICSplexQuery regionGroup(String name, Consumer<RegionGroupQuery> query) {
        this.regionGroupParser = this.objectField(REGION_GROUP, ac -> {
            ArgumentsContext argumentsContext = ac.argString(NAME, name);
        }, this.regionGroupQueryImpl, query);
        return this;
    }

    public CICSplexQuery cicsResources(Consumer<CICSResourcesQuery> query) {
        this.cicsResourcesParser = NodeParser.nonNull(this.objectField("cicsResources", new CICSResourcesQueryImpl(this.aggregationMeta), query));
        return this;
    }

    public CICSplexQuery cpsmManagers(Consumer<CPSMManagersQuery> query) {
        this.cpsmManagersParser = NodeParser.nonNull(this.objectField("cpsmManagers", new CPSMManagersQueryImpl(this.aggregationMeta), query));
        return this;
    }

    public CICSplexQuery fragment(FragmentReference<CICSplexQuery> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    @Override
    public CICSplexQueryResult parse(JsonObject o) {
        if (this.nameParser == null) {
            throw new NodeParseRuntimeException("CICSplex query node was missing required field 'name'");
        }
        return new CICSplexQueryResultImpl(this.nameParser.parse(o), CICSplexQueryImpl.parseOptionalResult(this.regionParser, o), CICSplexQueryImpl.parseOptionalList(this.regionsParser, o), CICSplexQueryImpl.parseOptionalResult(this.regionGroupParser, o), CICSplexQueryImpl.parseOptionalList(this.regionGroupsParser, o), CICSplexQueryImpl.parse(this.drepParser, o), CICSplexQueryImpl.parseMap(this.cicsResourcesParser, o), CICSplexQueryImpl.parseMap(this.cpsmManagersParser, o));
    }

    private static class CICSplexQueryResultImpl
    implements CICSplexQueryResult {
        private final String name;
        private final Optional<RegionQueryResult> regionResult;
        private final List<RegionQueryResult> regionsResult;
        private final Optional<RegionGroupQueryResult> regionGroupResult;
        private final List<RegionGroupQueryResult> regionGroupsResult;
        private final Optional<DREPQueryResult> drepResult;
        private final Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult> cicsResources;
        private final Map<ICICSType<? extends ICPSMManager>, CICSObjectRecordsQueryResult> cpsmManagers;

        public CICSplexQueryResultImpl(String name, Optional<RegionQueryResult> regionResult, List<RegionQueryResult> regionsResult, Optional<RegionGroupQueryResult> regionGroupResult, List<RegionGroupQueryResult> regionGroupsResult, Optional<DREPQueryResult> drepResult, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult> cicsResources, Map<ICICSType<? extends ICPSMManager>, CICSObjectRecordsQueryResult> cpsmManagers) {
            this.name = name;
            this.regionResult = regionResult;
            this.regionsResult = Collections.unmodifiableList(regionsResult);
            this.regionGroupResult = regionGroupResult;
            this.regionGroupsResult = Collections.unmodifiableList(regionGroupsResult);
            this.drepResult = drepResult;
            this.cicsResources = Collections.unmodifiableMap(cicsResources);
            this.cpsmManagers = Collections.unmodifiableMap(cpsmManagers);
        }

        public String getName() {
            return this.name;
        }

        public Optional<RegionQueryResult> getRegionResult() {
            return this.regionResult;
        }

        public List<RegionQueryResult> getRegionsResult() {
            return this.regionsResult;
        }

        public Optional<RegionGroupQueryResult> getRegionGroupResult() {
            return this.regionGroupResult;
        }

        public List<RegionGroupQueryResult> getRegionGroupsResult() {
            return this.regionGroupsResult;
        }

        public Optional<DREPQueryResult> getDREPResult() {
            return this.drepResult;
        }

        public Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult> getCICSResources() {
            return this.cicsResources;
        }

        public Map<ICICSType<? extends ICPSMManager>, CICSObjectRecordsQueryResult> getCPSMManagers() {
            return this.cpsmManagers;
        }
    }
}

