/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.query.CICSDefinitionsQuery;
import com.ibm.cics.model.query.CICSObjectRecordsQueryResult;
import com.ibm.cics.model.query.CPSMDefinitionsQuery;
import com.ibm.cics.model.query.DREPQuery;
import com.ibm.cics.model.query.DREPQueryResult;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.query.AggregationMeta;
import com.ibm.cics.sm.comm.sm.internal.query.CICSDefinitionsQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CPSMDefinitionsQueryImpl;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

class DREPQueryImpl
extends Node<DREPQueryResult>
implements DREPQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String GRAPH_QL_TYPE_NAME = "DREPType";
    private final CPSMDefinitionsQueryImpl cpsmDefQuery;
    private final CICSDefinitionsQueryImpl cicsDefQuery;
    private NodeParser<Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult>> cicsDefinitions;
    private NodeParser<Map<ICICSType<? extends ICPSMDefinition>, CICSObjectRecordsQueryResult>> cpsmDefinitions;

    public DREPQueryImpl(Map<ICICSType<?>, AggregationMeta> aggregationMeta) {
        super(GRAPH_QL_TYPE_NAME);
        this.cpsmDefQuery = new CPSMDefinitionsQueryImpl(aggregationMeta);
        this.cicsDefQuery = new CICSDefinitionsQueryImpl(aggregationMeta);
    }

    public DREPQueryImpl cicsDefinitions(Consumer<CICSDefinitionsQuery> query) {
        this.cicsDefinitions = NodeParser.nonNull(this.objectField("cicsDefinitions", this.cicsDefQuery, query));
        return this;
    }

    public DREPQueryImpl cpsmDefinitions(Consumer<CPSMDefinitionsQuery> query) {
        this.cpsmDefinitions = NodeParser.nonNull(this.objectField("cpsmDefinitions", this.cpsmDefQuery, query));
        return this;
    }

    public DREPQuery fragment(FragmentReference<DREPQuery> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    @Override
    public DREPQueryResult parse(JsonObject o) {
        return new DREPQueryResultImpl(DREPQueryImpl.parseMap(this.cicsDefinitions, o), DREPQueryImpl.parseMap(this.cpsmDefinitions, o));
    }

    private static class DREPQueryResultImpl
    implements DREPQueryResult {
        private final Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult> cicsDefinitions;
        private final Map<ICICSType<? extends ICPSMDefinition>, CICSObjectRecordsQueryResult> cpsmDefinitions;

        public DREPQueryResultImpl(Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult> cicsDefinitions, Map<ICICSType<? extends ICPSMDefinition>, CICSObjectRecordsQueryResult> cpsmDefinitions) {
            this.cicsDefinitions = Collections.unmodifiableMap(cicsDefinitions);
            this.cpsmDefinitions = Collections.unmodifiableMap(cpsmDefinitions);
        }

        public Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult> getCICSDefinitions() {
            return this.cicsDefinitions;
        }

        public Map<ICICSType<? extends ICPSMDefinition>, CICSObjectRecordsQueryResult> getCPSMDefinitions() {
            return this.cpsmDefinitions;
        }
    }
}

