/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.decorators;

import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.eclipse.common.ui.StyledStringHelper;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSType;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class CICSObjectReferenceLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof ICICSObject) {
            element = (ICICSObjectReference)((ICoreObject)element).getAdapter(ICICSObjectReference.class);
        }
        if (element instanceof ICICSObjectReference) {
            ICICSObjectReference ref = (ICICSObjectReference)element;
            Set keyAttributes = ref.getCICSType().getKeyAttributes();
            if (keyAttributes.size() > 0) {
                ICICSAttribute<?> nameAttribute = this.getNameAttribute(ref.getCICSType());
                String nameValue = this.getExternalAttributeValue(nameAttribute, ref);
                StyledString styledString = new StyledString(nameValue);
                ArrayList<String> decoratorValues = new ArrayList<String>();
                for (ICICSAttribute decoratorAttribute : keyAttributes) {
                    Object value = ref.getAttributeValue(decoratorAttribute);
                    if (!this.isSet(value, decoratorAttribute) || decoratorAttribute == nameAttribute) continue;
                    decoratorValues.add(this.getExternalAttributeValue(decoratorAttribute, ref));
                }
                StyledStringHelper.appendDecorations((StyledString)styledString, (Object[])decoratorValues.toArray());
                cell.setText(styledString.getString());
                cell.setStyleRanges(styledString.getStyleRanges());
            } else {
                cell.setText(Messages.getTableDescription(ref.getCICSType().getResourceTableName()));
            }
            cell.setImage(this.getImage(element));
        }
        super.update(cell);
    }

    private ICICSAttribute<?> getNameAttribute(ICICSType<?> type) {
        ICICSAttribute nameAttribute = null;
        String nameAttributeName = type.getNameAttribute();
        if (nameAttributeName != null) {
            nameAttribute = type.findAttributeByCicsName(nameAttributeName);
        }
        if (nameAttribute == null) {
            nameAttribute = (ICICSAttribute)type.getKeyAttributes().iterator().next();
        }
        return nameAttribute;
    }

    private boolean isSet(Object value, ICICSAttribute<?> attribute) {
        return value != attribute.getUnexpectedValue() && value != attribute.getUnsupportedValue() && value != null && (attribute != AbstractCICSDefinitionType.VERSION || (Long)value != 0L) && attribute != AbstractCICSDefinitionType.CSDGROUP;
    }

    public String getText(Object element) {
        ICICSObjectReference reference;
        if (element instanceof ICICSObjectReference) {
            ICICSObjectReference reference2 = (ICICSObjectReference)element;
            ICICSType type = reference2.getCICSType();
            String nameAttributeName = type.getNameAttribute();
            ICICSAttribute nameAttribute = type.findAttributeByCicsName(nameAttributeName);
            return this.getExternalAttributeValue(nameAttribute, reference2);
        }
        if (element instanceof ICICSObject && (reference = (ICICSObjectReference)((ICoreObject)element).getAdapter(ICICSObjectReference.class)) != null) {
            return this.getText(reference);
        }
        return null;
    }

    private <T> String getExternalAttributeValue(ICICSAttribute<T> attribute, ICICSObjectReference<?> reference) {
        Object attributeValue = reference.getAttributeValue(attribute);
        return attribute.internalToExternal(attributeValue);
    }

    public Image getImage(Object element) {
        ICICSObjectReference reference;
        if (element instanceof ICICSObjectReference) {
            ICICSType type = ((ICICSObjectReference)element).getCICSType();
            return UIPlugin.getTableImage(type.getResourceTableName());
        }
        if (element instanceof ICICSObject && (reference = (ICICSObjectReference)((ICoreObject)element).getAdapter(ICICSObjectReference.class)) != null) {
            return this.getImage(reference);
        }
        return null;
    }
}

