/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IConnectionProviderRegistry;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectionCredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.DebugOptions;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.HydratedConfigurationCache;
import java.util.List;
import java.util.Map;

public class ConnectionManager
implements IConnectionManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ConnectionManager.class);
    private final ConnectionCredentialsManager connectionCredentialsManager;
    private final HydratedConfigurationCache hydratedCache = new HydratedConfigurationCache();
    private final ConnectionProviderRegistry connectionProviderRegistry;
    private ConnectionRegistry connectionRegistry;

    public ConnectionManager(ConnectionProviderRegistry connectionProviderRegistry, ConnectionRegistry connectionRegistry, ConnectionCredentialsManager connectionCredentialsManager) {
        debug.enter("<init>");
        this.connectionProviderRegistry = connectionProviderRegistry;
        this.connectionRegistry = connectionRegistry;
        this.connectionCredentialsManager = connectionCredentialsManager;
        this.connectionCredentialsManager.addListener(new ConnectionCredentialsManager.ConnectionCredentialsManagerListener(){

            public void event(ConnectionCredentialsManager.ConnectionCredentialsManagerEvent event) {
                if (event instanceof ConnectionCredentialsManager.ConnectionCredentialsChangedEvent) {
                    String connectionId = ((ConnectionCredentialsManager.ConnectionCredentialsChangedEvent)event).getConnectionId();
                    ConnectionProfile oldConfiguration = ConnectionManager.this.hydratedCache.getConfiguration(connectionId);
                    if (oldConfiguration != null) {
                        IConnectionProvider provider = oldConfiguration.getConnectionProvider();
                        ConnectionParameters dried = oldConfiguration.getConnectionParameters();
                        ConnectionManager.this.hydrateAndUpdate(dried, provider, ((ConnectionCredentialsManager.ConnectionCredentialsChangedEvent)event).getCredentials());
                    }
                }
            }
        });
        for (IConnectionProvider connectionProvider : connectionProviderRegistry.getConnectionProviders()) {
            this.connectionProviderAdded(connectionProvider);
        }
        connectionProviderRegistry.addListener(new IConnectionProviderRegistry.ConnectionProviderRegistryListener(){

            public void event(IConnectionProviderRegistry.ConnectionProviderRegistryEvent event) {
                if (event instanceof IConnectionProviderRegistry.ConnectionProviderAddedEvent) {
                    ConnectionManager.this.connectionProviderAdded(event.getConnectionProvider());
                } else if (event instanceof IConnectionProviderRegistry.ConnectionProviderRemovedEvent) {
                    ConnectionManager.this.connectionProviderRemoved(event.getConnectionProvider());
                }
            }
        });
        debug.exit("<init>", (Object)this);
    }

    @Override
    public void addListener(ConnectionManagerListener listener) {
        if (DebugOptions.DEBUG_CONNECTION) {
            debug.enter("addListener", (Object)("listener=" + (Object)((Object)listener)));
        }
        this.hydratedCache.addListener(listener);
        if (DebugOptions.DEBUG_CONNECTION) {
            debug.exit("addListener", (Object)("listener=" + (Object)((Object)listener)));
        }
    }

    @Override
    public ICredentialsManager getCredentialsManager() {
        return this.connectionCredentialsManager.getCredentialsManager();
    }

    @Override
    public List<ConnectionProfile> getConnectionProfiles() {
        return this.hydratedCache.getConfigurations();
    }

    private List<List<ConnectionProfile>> getConfigurationsGroupedByDescriptor() {
        return CollectionUtils.groupBy(this.getConnectionProfiles(), new Function<ConnectionProfile, IConnectionDescriptor>(){

            @Override
            public IConnectionDescriptor evaluate(ConnectionProfile v) {
                return v.getConnectionDescriptor();
            }
        });
    }

    @Override
    public Map<IConnectionDescriptor, List<ConnectionProfile>> getConnectionProfilesByDescriptor() {
        return CollectionUtils.map(this.getConfigurationsGroupedByDescriptor(), new Function<List<ConnectionProfile>, IConnectionDescriptor>(){

            @Override
            public IConnectionDescriptor evaluate(List<ConnectionProfile> v) {
                return v.get(0).getConnectionDescriptor();
            }
        });
    }

    private void connectionProviderAdded(IConnectionProvider connectionProvider) {
        CacheUpdatingListener listener = new CacheUpdatingListener(connectionProvider);
        for (ConnectionParameters freezeDried : connectionProvider.getConnections()) {
            this.hydrateAndUpdate(freezeDried, connectionProvider, this.connectionCredentialsManager.getCredentials(freezeDried.getId()));
        }
        connectionProvider.addListener(listener);
    }

    private void connectionProviderRemoved(IConnectionProvider provider) {
        for (ConnectionParameters config : provider.getConnections()) {
            this.hydratedCache.remove(config.getId());
        }
    }

    private void hydrateAndUpdate(ConnectionParameters dried, IConnectionProvider connectionProvider, CredentialsConfiguration credentials) {
        IConnectionDescriptor descriptor = this.connectionRegistry.find(dried.getConnectionTypeId());
        if (descriptor != null) {
            ConnectionProfile hydratedConfig = new ConnectionProfile(dried, descriptor, credentials, connectionProvider);
            this.hydratedCache.update(hydratedConfig);
        } else {
            this.hydratedCache.remove(dried.getId());
        }
    }

    @Override
    public ConnectionProfile getConnectionProfile(String id) {
        return this.hydratedCache.getConfiguration(id);
    }

    public ConnectionCredentialsManager getConnectionCredentialsManager() {
        return this.connectionCredentialsManager;
    }

    @Override
    public List<ConnectionProfile> getConnectionProfiles(String connectionTypeId) {
        final IConnectionDescriptor targetDescriptor = this.connectionRegistry.find(connectionTypeId);
        return CollectionUtils.filter(this.getConnectionProfiles(), new Function<ConnectionProfile, Boolean>(){

            @Override
            public Boolean evaluate(ConnectionProfile v) {
                if (v.getConnectionDescriptor() == targetDescriptor) {
                    return true;
                }
                return false;
            }
        });
    }

    private final class CacheUpdatingListener
    extends IConnectionProvider.ConnectionProviderListener {
        private final IConnectionProvider connectionProvider;

        private CacheUpdatingListener(IConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public void event(IConnectionProvider.ConnectionProviderEvent event) {
            if (event instanceof IConnectionProvider.ConnectionParametersAddedEvent) {
                ConnectionParameters driedConfig = ((IConnectionProvider.ConnectionParametersAddedEvent)event).getConnectionParameters();
                ConnectionManager.this.hydrateAndUpdate(driedConfig, this.connectionProvider, ConnectionManager.this.connectionCredentialsManager.getCredentials(driedConfig.getId()));
            } else if (event instanceof IConnectionProvider.ConnectionParametersRemovedEvent) {
                String id = ((IConnectionProvider.ConnectionParametersRemovedEvent)event).getConnectionParameters().getId();
                ConnectionManager.this.hydratedCache.remove(id);
            } else if (event instanceof IConnectionProvider.ConnectionParametersUpdatedEvent) {
                ConnectionParameters driedConfig = ((IConnectionProvider.ConnectionParametersUpdatedEvent)event).getConnectionParameters();
                ConnectionManager.this.hydrateAndUpdate(driedConfig, this.connectionProvider, ConnectionManager.this.connectionCredentialsManager.getCredentials(driedConfig.getId()));
            }
        }

        public synchronized boolean isStale() {
            return !ConnectionManager.this.connectionProviderRegistry.getConnectionProviders().contains(this.connectionProvider);
        }
    }
}

