/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.IConnectionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ConnectionParametersCache {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, ConnectionParameters> connectionCacheMap = new HashMap<String, ConnectionParameters>();

    public synchronized Collection<ConnectionParameters> getConfigurations() {
        return Collections.unmodifiableCollection(this.connectionCacheMap.values());
    }

    public synchronized ConnectionParameters getConfiguration(String configurationId) {
        return this.connectionCacheMap.get(configurationId);
    }

    public synchronized IConnectionProvider.ConnectionProviderEvent update(ConnectionParameters parameters) {
        ConnectionParameters oldParameters = this.connectionCacheMap.put(parameters.getId(), parameters);
        if (oldParameters != null) {
            return new IConnectionProvider.ConnectionParametersUpdatedEvent(oldParameters, parameters);
        }
        return new IConnectionProvider.ConnectionParametersAddedEvent(parameters);
    }

    public synchronized List<IConnectionProvider.ConnectionProviderEvent> update(List<ConnectionParameters> newCsList) {
        ArrayList<IConnectionProvider.ConnectionProviderEvent> events = new ArrayList<IConnectionProvider.ConnectionProviderEvent>();
        HashSet<String> cacheKeys = new HashSet<String>(this.connectionCacheMap.keySet());
        Map<String, ConnectionParameters> newCs = this.map(newCsList);
        for (String configurationId : cacheKeys) {
            ConnectionParameters cachedC = this.connectionCacheMap.get(configurationId);
            ConnectionParameters newC = newCs.get(configurationId);
            if (newC == null) {
                this.connectionCacheMap.remove(configurationId);
                events.add(new IConnectionProvider.ConnectionParametersRemovedEvent(cachedC));
            } else if (newC != null && !newC.equals(cachedC)) {
                this.connectionCacheMap.put(configurationId, newC);
                events.add(new IConnectionProvider.ConnectionParametersUpdatedEvent(cachedC, newC));
            }
            newCs.remove(configurationId);
        }
        for (ConnectionParameters newC : newCs.values()) {
            this.connectionCacheMap.put(newC.getId(), newC);
            events.add(new IConnectionProvider.ConnectionParametersAddedEvent(newC));
        }
        return events;
    }

    private Map<String, ConnectionParameters> map(List<ConnectionParameters> newCsList) {
        HashMap<String, ConnectionParameters> newCs = new HashMap<String, ConnectionParameters>();
        for (ConnectionParameters newC : newCsList) {
            newCs.put(newC.getId(), newC);
        }
        return newCs;
    }

    public synchronized IConnectionProvider.ConnectionProviderEvent remove(String id) {
        ConnectionParameters connectionParameters = this.connectionCacheMap.remove(id);
        if (connectionParameters != null) {
            return new IConnectionProvider.ConnectionParametersRemovedEvent(connectionParameters);
        }
        return null;
    }
}

