/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.builders;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DefinitionBuilder;
import com.ibm.cics.core.model.ResourceInDescriptionEntryType;
import com.ibm.cics.core.model.builders.BuilderHelper;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.IResourceDescriptionDefinitionReference;
import com.ibm.cics.model.IResourceGroupDefinitionReference;
import com.ibm.cics.model.IResourceInDescriptionEntry;
import com.ibm.cics.model.IResourceInDescriptionEntryReference;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableResourceInDescriptionEntry;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class ResourceInDescriptionEntryBuilder
extends DefinitionBuilder
implements IMutableResourceInDescriptionEntry {
    private MutableSMRecord record = new MutableSMRecord("RESINDSC");

    public ResourceInDescriptionEntryBuilder(String _resourceDescription, String _resourceGroup) {
        this.setResourceDescription(_resourceDescription);
        this.setResourceGroup(_resourceGroup);
    }

    public ResourceInDescriptionEntryBuilder(String _resourceDescription, String _resourceGroup, IResourceInDescriptionEntry anotherDef) throws Exception {
        this(_resourceDescription, _resourceGroup);
        BuilderHelper.copyAttributes((IDefinition)anotherDef, this);
    }

    public ICPSMDefinitionContainer getCICSContainer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SMConnectionRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getRecord() + "]";
    }

    public void setResourceDescription(String _resourceDescription) {
        String connectionSpecificExternalValue = null;
        if (_resourceDescription != null && _resourceDescription != ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION.getUnsupportedValue()) {
            ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION.validate((Object)_resourceDescription);
            connectionSpecificExternalValue = ((CICSAttribute)ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION).set(_resourceDescription, this.record.getNormalizers());
        }
        this.record.set("RESDESC", connectionSpecificExternalValue);
    }

    public void setResourceGroup(String _resourceGroup) {
        String connectionSpecificExternalValue = null;
        if (_resourceGroup != null && _resourceGroup != ResourceInDescriptionEntryType.RESOURCE_GROUP.getUnsupportedValue()) {
            ResourceInDescriptionEntryType.RESOURCE_GROUP.validate((Object)_resourceGroup);
            connectionSpecificExternalValue = ((CICSAttribute)ResourceInDescriptionEntryType.RESOURCE_GROUP).set(_resourceGroup, this.record.getNormalizers());
        }
        this.record.set("RESGROUP", connectionSpecificExternalValue);
    }

    public void setDescription(String _description) {
        String connectionSpecificExternalValue = null;
        if (_description != null && _description != ResourceInDescriptionEntryType.DESCRIPTION.getUnsupportedValue()) {
            ResourceInDescriptionEntryType.DESCRIPTION.validate((Object)_description);
            connectionSpecificExternalValue = ((CICSAttribute)ResourceInDescriptionEntryType.DESCRIPTION).set(_description, this.record.getNormalizers());
        }
        this.record.set("DESCRIPTION", connectionSpecificExternalValue);
    }

    public String getResourceDescription() {
        String result = this.record.get("RESDESC");
        return result == null ? null : (String)((CICSAttribute)ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public String getResourceGroup() {
        String result = this.record.get("RESGROUP");
        return result == null ? null : (String)((CICSAttribute)ResourceInDescriptionEntryType.RESOURCE_GROUP).get(result, this.record.getNormalizers());
    }

    @Override
    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        return result == null ? null : (String)((CICSAttribute)ResourceInDescriptionEntryType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    @Override
    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION) {
            return (V)this.getResourceDescription();
        }
        if (attribute == ResourceInDescriptionEntryType.RESOURCE_GROUP) {
            return (V)this.getResourceGroup();
        }
        if (attribute == ResourceInDescriptionEntryType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + ResourceInDescriptionEntryType.getInstance());
    }

    @Override
    public <V> void setAttributeValue(IAttribute<V> attribute, V value) {
        if (attribute == ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION) {
            this.setResourceDescription((String)ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION.getType().cast(value));
        } else if (attribute == ResourceInDescriptionEntryType.RESOURCE_GROUP) {
            this.setResourceGroup((String)ResourceInDescriptionEntryType.RESOURCE_GROUP.getType().cast(value));
        } else if (attribute == ResourceInDescriptionEntryType.DESCRIPTION) {
            this.setDescription((String)ResourceInDescriptionEntryType.DESCRIPTION.getType().cast(value));
        } else {
            throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not settable for type " + ResourceInDescriptionEntryType.getInstance());
        }
    }

    public ResourceInDescriptionEntryType getObjectType() {
        return ResourceInDescriptionEntryType.getInstance();
    }

    public IResourceInDescriptionEntryReference getCICSObjectReference() {
        return null;
    }

    public IResourceGroupDefinitionReference getToResourceGroup() {
        throw new UnsupportedOperationException();
    }

    public IResourceDescriptionDefinitionReference getToResourceDescription() {
        throw new UnsupportedOperationException();
    }
}

