/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.MonitorDefinitionReference;
import com.ibm.cics.core.model.MonitorDefinitionType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IMonitorDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableMonitorDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableMonitorDefinition
extends MutableCPSMDefinition
implements IMutableMonitorDefinition {
    private IMonitorDefinition delegate;
    private MutableSMRecord record;

    public MutableMonitorDefinition(ICPSM cpsm, IContext context, IMonitorDefinition cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("MONDEF");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getResourceName() {
        String result = this.record.get("RESNAME");
        if (result == null) {
            return this.delegate.getResourceName();
        }
        return (String)((CICSAttribute)MonitorDefinitionType.RESOURCE_NAME).get(result, this.record.getNormalizers());
    }

    public IMonitorDefinition.ResourceClassValue getResourceClass() {
        String result = this.record.get("RESCLASS");
        if (result == null) {
            return this.delegate.getResourceClass();
        }
        return (IMonitorDefinition.ResourceClassValue)((CICSAttribute)MonitorDefinitionType.RESOURCE_CLASS).get(result, this.record.getNormalizers());
    }

    public IMonitorDefinition.IncludeValue getInclude() {
        String result = this.record.get("INCLUDE");
        if (result == null) {
            return this.delegate.getInclude();
        }
        return (IMonitorDefinition.IncludeValue)((CICSAttribute)MonitorDefinitionType.INCLUDE).get(result, this.record.getNormalizers());
    }

    public String getDescription() {
        String result = this.record.get("DESC");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)MonitorDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public IMonitorDefinition.ResourceStatusPopulationValue getResourceStatusPopulation() {
        String result = this.record.get("RODMPOP");
        if (result == null) {
            return this.delegate.getResourceStatusPopulation();
        }
        return (IMonitorDefinition.ResourceStatusPopulationValue)((CICSAttribute)MonitorDefinitionType.RESOURCE_STATUS_POPULATION).get(result, this.record.getNormalizers());
    }

    public void setResourceName(String _resourceName) {
        if (_resourceName.equals(this.delegate.getResourceName())) {
            this.record.set("RESNAME", null);
        } else {
            MonitorDefinitionType.RESOURCE_NAME.validate((Object)_resourceName);
            String connectionSpecificExternalValue = ((CICSAttribute)MonitorDefinitionType.RESOURCE_NAME).set(_resourceName, this.record.getNormalizers());
            this.record.set("RESNAME", connectionSpecificExternalValue);
        }
    }

    public void setResourceClass(IMonitorDefinition.ResourceClassValue _resourceClass) {
        if (_resourceClass.equals((Object)this.delegate.getResourceClass())) {
            this.record.set("RESCLASS", null);
        } else {
            MonitorDefinitionType.RESOURCE_CLASS.validate((Object)_resourceClass);
            String connectionSpecificExternalValue = ((CICSAttribute)MonitorDefinitionType.RESOURCE_CLASS).set(_resourceClass, this.record.getNormalizers());
            this.record.set("RESCLASS", connectionSpecificExternalValue);
        }
    }

    public void setInclude(IMonitorDefinition.IncludeValue _include) {
        if (_include.equals((Object)this.delegate.getInclude())) {
            this.record.set("INCLUDE", null);
        } else {
            MonitorDefinitionType.INCLUDE.validate((Object)_include);
            String connectionSpecificExternalValue = ((CICSAttribute)MonitorDefinitionType.INCLUDE).set(_include, this.record.getNormalizers());
            this.record.set("INCLUDE", connectionSpecificExternalValue);
        }
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESC", null);
        } else {
            MonitorDefinitionType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)MonitorDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESC", connectionSpecificExternalValue);
        }
    }

    public void setResourceStatusPopulation(IMonitorDefinition.ResourceStatusPopulationValue _resourceStatusPopulation) {
        if (_resourceStatusPopulation.equals((Object)this.delegate.getResourceStatusPopulation())) {
            this.record.set("RODMPOP", null);
        } else {
            MonitorDefinitionType.RESOURCE_STATUS_POPULATION.validate((Object)_resourceStatusPopulation);
            String connectionSpecificExternalValue = ((CICSAttribute)MonitorDefinitionType.RESOURCE_STATUS_POPULATION).set(_resourceStatusPopulation, this.record.getNormalizers());
            this.record.set("RODMPOP", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == MonitorDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == MonitorDefinitionType.RESOURCE_NAME) {
            return (V)this.getResourceName();
        }
        if (attribute == MonitorDefinitionType.RESOURCE_CLASS) {
            return (V)this.getResourceClass();
        }
        if (attribute == MonitorDefinitionType.INCLUDE) {
            return (V)this.getInclude();
        }
        if (attribute == MonitorDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == MonitorDefinitionType.RESOURCE_STATUS_POPULATION) {
            return (V)this.getResourceStatusPopulation();
        }
        return super.getAttributeValue(attribute);
    }

    public MonitorDefinitionType getObjectType() {
        return MonitorDefinitionType.getInstance();
    }

    @Override
    public MonitorDefinitionReference getCICSObjectReference() {
        return new MonitorDefinitionReference(this.getCICSContainer(), this.getName());
    }
}

