/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IDFactory;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectionParametersCache;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public abstract class AbstractConnectionProvider
implements IConnectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ConnectionRegistry registry;
    private final String id;
    private ConnectionParametersCache cache;
    private EventManager<IConnectionProvider.ConnectionProviderEvent> eventManager = new EventManager();
    private static final Debug debug = new Debug(AbstractConnectionProvider.class);

    public AbstractConnectionProvider(String id) {
        this(id, ConnectionRegistry.getConnectionRegistry());
    }

    protected AbstractConnectionProvider(String id, ConnectionRegistry registry) {
        this.id = id;
        this.registry = registry;
        this.cache = new ConnectionParametersCache();
    }

    public void clear() {
        List<ConnectionParameters> emptyList = Collections.emptyList();
        this.cache.update(emptyList);
    }

    @Override
    public String getId() {
        debug.enter("getId");
        debug.exit("getId", (Object)this.id);
        return this.id;
    }

    @Override
    public Collection<ConnectionParameters> getConnections() {
        debug.enter("getConnections");
        Collection<ConnectionParameters> configurations = this.cache.getConfigurations();
        debug.exit("getConnections", configurations);
        return configurations;
    }

    @Override
    public ConnectionParameters getConnection(String configurationId) {
        debug.enter("getConnection", (Object)configurationId);
        ConnectionParameters configuration = this.cache.getConfiguration(configurationId);
        debug.exit("getConnections", (Object)configuration);
        return configuration;
    }

    @Override
    public IStatus refresh(IProgressMonitor monitor) {
        debug.enter("refresh", (Object)monitor);
        List<ConnectionParameters> updatedConfigurations = this.getUpdatedConfigurations(monitor);
        updatedConfigurations = CollectionUtils.transform(updatedConfigurations, new Function<ConnectionParameters, ConnectionParameters>(){

            @Override
            public ConnectionParameters evaluate(ConnectionParameters v) {
                return AbstractConnectionProvider.this.denormalize(v);
            }
        });
        List<IConnectionProvider.ConnectionProviderEvent> events = this.cache.update(updatedConfigurations);
        for (IConnectionProvider.ConnectionProviderEvent event : events) {
            this.eventManager.notifyListeners((Object)event);
        }
        IStatus status = this.getStatus();
        this.eventManager.notifyListeners((Object)new IConnectionProvider.ConnectionProviderStatusChangedEvent(status));
        debug.exit("refresh", (Object)status);
        return status;
    }

    private ConnectionParameters denormalize(ConnectionParameters parameters) {
        IConnectionDescriptor descriptor = this.registry.find(parameters.getConnectionTypeId());
        if (descriptor != null) {
            for (Map.Entry<String, String> attribute : parameters.getAttributes().entrySet()) {
                if (!ConnectionUtils.isIdReference(descriptor, attribute.getKey())) continue;
                parameters = parameters.setAttribute(attribute.getKey(), this.denormalizeIdReference(attribute.getValue()));
            }
        }
        return parameters.setId(this.getExternalId(parameters.getId()));
    }

    private String denormalizeIdReference(String id) {
        return ConnectionUtils.isInternalId(id) ? this.getExternalId(id) : id;
    }

    protected abstract List<ConnectionParameters> getUpdatedConfigurations(IProgressMonitor var1);

    protected abstract IStatus getStatus();

    protected void notifyStale() {
        debug.enter("notifyStale");
        this.eventManager.notifyListeners((Object)new IConnectionProvider.ConnectionProviderStaleEvent());
        debug.exit("notifyStale");
    }

    @Override
    public void addListener(IConnectionProvider.ConnectionProviderListener listener) {
        debug.enter("addListener", (Object)listener);
        this.eventManager.addListener((IStaleableEventListener)listener);
        debug.exit("addListener");
    }

    protected String getUnusedLocalId() {
        debug.enter("getUnusedLocalId");
        List<String> usedIds = CollectionUtils.transform(this.cache.getConfigurations(), new Function<ConnectionParameters, String>(){

            @Override
            public String evaluate(ConnectionParameters v) {
                return AbstractConnectionProvider.getInternalId(v.getId());
            }
        });
        String newId = IDFactory.createNewId();
        while (usedIds.contains(newId)) {
            newId = IDFactory.createNewId();
        }
        debug.exit("getUnusedLocalId", (Object)newId);
        return newId;
    }

    private String getExternalId(String internalId) {
        debug.enter("getExternalId", (Object)internalId);
        String externalId = String.valueOf(internalId) + '@' + this.getId();
        debug.exit("getExternalId", (Object)externalId);
        return externalId;
    }

    protected static String getInternalId(String externalId) {
        return ConnectionUtils.getInternalId(externalId);
    }

    protected ConnectionParameters putConnectionParameters(ConnectionParameters newParameters) {
        debug.enter("updateConnectionParameters", (Object)newParameters);
        IConnectionProvider.ConnectionProviderEvent event = this.cache.update(newParameters);
        this.eventManager.notifyListeners((Object)event);
        debug.exit("updateConnectionParameters", (Object)newParameters);
        return newParameters;
    }

    protected ConnectionParameters createNewConnectionParameters(String internalId, String name, String connectionTypeId, Map<String, String> attributes) {
        debug.enter("createNewConnectionParameters", (Object)internalId, (Object)name, (Object)connectionTypeId, attributes);
        ConnectionParameters newParameters = new ConnectionParameters(this.getExternalId(internalId), name, connectionTypeId, attributes);
        ConnectionParameters newConnectionParameters = this.putConnectionParameters(newParameters);
        debug.exit("createNewConnectionParameters", (Object)newConnectionParameters);
        return newConnectionParameters;
    }

    protected void removeConnectionParameters(String id) {
        debug.enter("removeConnectionParameters", (Object)id);
        IConnectionProvider.ConnectionProviderEvent event = this.cache.remove(id);
        if (event != null) {
            this.eventManager.notifyListeners((Object)event);
        }
        debug.exit("removeConnectionParameters");
    }
}

