/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ConnectablesRegistry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug debug = new Debug(ConnectablesRegistry.class);
    private Map<String, IConfigurationElement> connectableElements = new HashMap<String, IConfigurationElement>();

    public ConnectablesRegistry() {
        this.registerConnectables();
    }

    private void registerConnectables() {
        IExtension[] extensions;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cics.core.connections", "connectable");
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.readExtension(extension);
            ++n2;
        }
    }

    private void readExtension(IExtension extension) {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            this.readConfigurationElement(configurationElement);
            ++n2;
        }
    }

    private void readConfigurationElement(IConfigurationElement configurationElement) {
        if (configurationElement.getName().equals("connectable")) {
            String categoryId = configurationElement.getAttribute("categoryId");
            if (categoryId != null) {
                this.connectableElements.put(categoryId, configurationElement);
            } else {
                debug.warning("registerConnectables", (Object)("Category ID was null " + configurationElement.getContributor().getName()));
            }
        }
    }

    public IConnectable loadConnectable(String connectionCategoryId) {
        IConfigurationElement connectableElement = this.connectableElements.get(connectionCategoryId);
        if (connectableElement != null) {
            try {
                return (IConnectable)connectableElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                debug.error("loadConnectable", "failed loading connectable for category '" + connectionCategoryId + "'", (Throwable)e);
            }
        }
        return null;
    }
}

