/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectionParametersExporter;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import com.ibm.cics.core.connections.internal.IConnectionSerializer;
import com.ibm.cics.core.connections.internal.ReadableConnectionProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class WritableConnectionProvider
extends ReadableConnectionProvider
implements IWritableConnectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(WritableConnectionProvider.class);
    private final IConnectionSerializer serializer;
    private final String description;
    private final ConnectionRegistry registry;

    public WritableConnectionProvider(String id, String description, IConnectionSerializer serializer, IConnectionDeserializer deserializer, ConnectionRegistry registry) {
        super(id, deserializer, registry);
        this.description = description;
        this.serializer = serializer;
        this.registry = registry;
    }

    @Override
    public void clear() {
        super.clear();
        this.save();
    }

    @Override
    public void removeConfiguration(String id) {
        super.removeConnectionParameters(id);
        this.save();
    }

    @Override
    public void updateConnectionParameters(ConnectionParameters newConfiguration) {
        super.putConnectionParameters(newConfiguration);
        this.save();
    }

    public ConnectionParameters createConnectionParameters(String localId, String name, String connectionTypeId, Map<String, String> attributes) {
        List<String> usedIds = CollectionUtils.transform(this.getConnections(), new Function<ConnectionParameters, String>(){

            @Override
            public String evaluate(ConnectionParameters v) {
                return WritableConnectionProvider.getInternalId(v.getId());
            }
        });
        if (usedIds.contains(localId)) {
            throw new IllegalArgumentException("Supplied ID \"" + localId + "\"was not unique for " + this.getDescription());
        }
        ConnectionParameters newConfiguration = super.createNewConnectionParameters(localId, name, connectionTypeId, attributes);
        this.save();
        return newConfiguration;
    }

    @Override
    public ConnectionParameters createConnectionParameters(String name, String connectionTypeId, Map<String, String> attributes) {
        ConnectionParameters newConfiguration = super.createNewConnectionParameters(this.getUnusedLocalId(), name, connectionTypeId, attributes);
        this.save();
        return newConfiguration;
    }

    @Override
    public ConnectionParameters createConnectionParameters(String name, String connectionTypeId, ConnectionParameters.AttributeValue ... attributes) {
        return this.createConnectionParameters(name, connectionTypeId, ConnectionParameters.AttributeValue.mapify(Arrays.asList(attributes)));
    }

    private String getExternalId(String internalId) {
        debug.enter("getExternalId", (Object)internalId);
        String externalId = String.valueOf(internalId) + '@' + this.getId();
        debug.exit("getExternalId", (Object)externalId);
        return externalId;
    }

    private void save() {
        List<String> idsList = CollectionUtils.transform(this.getConnections(), new Function<ConnectionParameters, String>(){

            @Override
            public String evaluate(ConnectionParameters v) {
                return WritableConnectionProvider.getInternalId(v.getId());
            }
        });
        final Map<String, String> idsMap = CollectionUtils.map(idsList, new Function<String, String>(){

            @Override
            public String evaluate(String v) {
                return WritableConnectionProvider.this.getExternalId(v);
            }
        });
        List<ConnectionParameters> connections = CollectionUtils.transform(this.getConnections(), new Function<ConnectionParameters, ConnectionParameters>(){

            @Override
            public ConnectionParameters evaluate(ConnectionParameters v) {
                return ConnectionParametersExporter.updateReferences(v, WritableConnectionProvider.this.registry, idsMap).setId(WritableConnectionProvider.getInternalId(v.getId()));
            }
        });
        try {
            this.serializer.save(connections);
        }
        catch (IOException e) {
            debug.error("Unable to save connection provider: " + this.getClass() + ", " + this.getId() + ", " + this.serializer, (Throwable)e);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

