/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.internal.ConnectionBoundEditorManager;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import com.ibm.cics.eclipse.common.ViewHelper;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConnectionsStartup
implements IStartup {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Debug debug = new Debug(this.getClass());

    public void earlyStartup() {
        this.debug.enter("earlyStartup", (Object)this);
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                if (workbenchWindow != null) {
                    ConnectionsStartup.this.debug.event("earlyStartup", (Object)this, (Object)workbenchWindow);
                    final ConnectionBoundEditorManager editorManager = new ConnectionBoundEditorManager(InternalConnectionsPlugin.getDefault().getWorkbench());
                    InternalConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(new ConnectionServiceListener(){

                        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                            IConnectionState state = InternalConnectionsPlugin.getDefault().getConnectionService().getConnectionState(event.getConnectionProfile().getConnectionDescriptor().getCategory().getId());
                            if (event instanceof ConnectionServiceListener.DisconnectingEvent) {
                                if (!editorManager.tryCloseEditors(event.getConnectable())) {
                                    ((ConnectionServiceListener.DisconnectingEvent)event).veto();
                                }
                            } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                                Exception exception = ((ConnectionServiceListener.ExceptionEvent)event).getException();
                                if (exception != null) {
                                    String message = exception.getMessage() != null && !exception.getMessage().isEmpty() ? exception.getMessage() : state.getMessage();
                                    ViewHelper.setDeferredStatusErrorMessage((String)message);
                                }
                            } else if (event instanceof ConnectionServiceListener.ConnectedEvent || event instanceof ConnectionServiceListener.DisconnectedEvent) {
                                ViewHelper.setDeferredStatusInformationMessage((String)state.getMessage());
                            }
                        }
                    });
                }
            }
        });
        this.debug.exit("earlyStartup");
    }
}

