/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.internal.FileConnectionProvider;
import com.ibm.cics.core.connections.internal.Messages;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ExplorerConnectionProvider
extends FileConnectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ExplorerConnectionProvider() {
        super("PRESET_CONNECTIONS", ExplorerConnectionProvider.getExplorerConnectionsDefaultFileLocation());
    }

    public static boolean fileExists() {
        File file = new File(ExplorerConnectionProvider.getExplorerConnectionsDefaultFileLocation().toOSString());
        return file.exists();
    }

    public static IPath getExplorerConnectionsDefaultFileLocation() {
        String launcher = System.getProperty("eclipse.launcher");
        if (launcher == null) {
            launcher = "launcher/cant/be/found";
        }
        Path eclipseEXEPath = new Path(launcher);
        IPath eclipseEXEFolder = eclipseEXEPath.removeLastSegments(1);
        return eclipseEXEFolder.append("connections.pref");
    }

    @Override
    public String getDescription() {
        return Messages.ExplorerConnectionProvider_presetConnections;
    }
}

