/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.common.util.SimpleValidationHelper;
import com.ibm.cics.model.ICICSLongAttributeHint;
import com.ibm.cics.model.meta.IllegalAttributeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class CICSLongAttributeHint
implements ICICSLongAttributeHint {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private long[] range;
    private final Map<String, Long> specialValuesWithoutExtraValues;
    private final Map<String, Long> specialValues;

    public CICSLongAttributeHint(long min, long max, SpecialValue[] specialValues, Long[] extraValues) {
        this.range = new long[]{min, max};
        this.specialValuesWithoutExtraValues = specialValues != null ? Collections.unmodifiableMap(Arrays.stream(specialValues).collect(Collectors.toMap(SpecialValue::getMnemonic, SpecialValue::getValue))) : Collections.emptyMap();
        if (extraValues != null) {
            HashMap<String, Long> tempSpecialValues = new HashMap<String, Long>(this.specialValuesWithoutExtraValues);
            Long[] longArray = extraValues;
            int n = extraValues.length;
            int n2 = 0;
            while (n2 < n) {
                Long extraValue = longArray[n2];
                tempSpecialValues.put(extraValue.toString(), extraValue);
                ++n2;
            }
            this.specialValues = Collections.unmodifiableMap(tempSpecialValues);
        } else {
            this.specialValues = this.specialValuesWithoutExtraValues;
        }
    }

    public CICSLongAttributeHint(long min, long max) {
        this(min, max, null, null);
    }

    public void validate(Long value) throws IllegalAttributeException {
        SimpleValidationHelper.validateNotNull((Object)value, null);
        if (this.hasSpecialValues()) {
            SimpleValidationHelper.validateMinMaxInclusiveOrSpecial((Long)value, (long)this.range[0], (long)this.range[1], this.getSpecialValues().values());
        } else {
            SimpleValidationHelper.validateMinMaxInclusive((Long)value, (long)this.range[0], (long)this.range[1]);
        }
    }

    public long[] getNumericRange() {
        return this.range;
    }

    public boolean hasSpecialValues() {
        return this.specialValues.size() > 0;
    }

    public Map<String, Long> getSpecialValues() {
        return this.specialValues;
    }

    public Map<String, Long> getSpecialValuesWithoutExtraValues() {
        return this.specialValuesWithoutExtraValues;
    }

    public static SpecialValue s(String mnemonic, Long value) {
        return new SpecialValue(mnemonic, value);
    }

    public static class SpecialValue {
        private final String mnemonic;
        private final Long value;
        public static final String NO_MNEMONIC = new String("");

        public SpecialValue(String mnemonic, Long value) {
            this.mnemonic = mnemonic;
            this.value = value;
        }

        public String getMnemonic() {
            return this.mnemonic;
        }

        public Long getValue() {
            return this.value;
        }
    }
}

