/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionReference;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IGroupSystemGroupEntry;
import com.ibm.cics.model.IResourceAssignmentDefinition;
import com.ibm.cics.model.IResourceAssignmentInResourceDescription;
import com.ibm.cics.model.IResourceDescriptionDefinition;
import com.ibm.cics.model.ISystemSystemGroupEntry;
import com.ibm.cics.model.IWLMSpecificationsToSystemGroup;
import com.ibm.cics.model.IWorkloadDefinition;
import com.ibm.cics.model.IWorkloadSpecification;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableCICSRegionGroupDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableCICSRegionGroupDefinition
extends MutableCPSMDefinition
implements IMutableCICSRegionGroupDefinition {
    private ICICSRegionGroupDefinition delegate;
    private MutableSMRecord record;

    public MutableCICSRegionGroupDefinition(ICPSM cpsm, IContext context, ICICSRegionGroupDefinition cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("CSYSGRP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getGroup() {
        return this.delegate.getGroup();
    }

    public String getDescription() {
        String result = this.record.get("DESC");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)CICSRegionGroupDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public String getPlatdef() {
        return this.delegate.getPlatdef();
    }

    public String getRegiontype() {
        return this.delegate.getRegiontype();
    }

    public ICICSRegionGroupDefinition.CreateOriginValue getCreateOrigin() {
        return this.delegate.getCreateOrigin();
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESC", null);
        } else {
            CICSRegionGroupDefinitionType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)CICSRegionGroupDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESC", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == CICSRegionGroupDefinitionType.GROUP) {
            return (V)this.getGroup();
        }
        if (attribute == CICSRegionGroupDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == CICSRegionGroupDefinitionType.PLATDEF) {
            return (V)this.getPlatdef();
        }
        if (attribute == CICSRegionGroupDefinitionType.REGIONTYPE) {
            return (V)this.getRegiontype();
        }
        if (attribute == CICSRegionGroupDefinitionType.CREATE_ORIGIN) {
            return (V)this.getCreateOrigin();
        }
        return super.getAttributeValue(attribute);
    }

    public CICSRegionGroupDefinitionType getObjectType() {
        return CICSRegionGroupDefinitionType.getInstance();
    }

    @Override
    public CICSRegionGroupDefinitionReference getCICSObjectReference() {
        return new CICSRegionGroupDefinitionReference(this.getCICSContainer(), this.getGroup());
    }

    public ICICSObjectSet<IGroupSystemGroupEntry> getAsParent() {
        return CICSRegionGroupDefinitionType.AS_PARENT.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IGroupSystemGroupEntry> getAsChild() {
        return CICSRegionGroupDefinitionType.AS_CHILD.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<ISystemSystemGroupEntry> getSystemsInGroup() {
        return CICSRegionGroupDefinitionType.SYSTEMS_IN_GROUP.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IWLMSpecificationsToSystemGroup> getFromWLMSpecificationsToSystemGroups() {
        return CICSRegionGroupDefinitionType.FROM_WLM_SPECIFICATIONS_TO_SYSTEM_GROUPS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IResourceAssignmentDefinition> getFromTargetScopeResourceAssignment() {
        return CICSRegionGroupDefinitionType.FROM_TARGET_SCOPE_RESOURCE_ASSIGNMENT.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IResourceAssignmentDefinition> getFromRelatedScopeResourceAssignment() {
        return CICSRegionGroupDefinitionType.FROM_RELATED_SCOPE_RESOURCE_ASSIGNMENT.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IResourceAssignmentInResourceDescription> getFromAssignmentsInDescriptionsRelatedScope() {
        return CICSRegionGroupDefinitionType.FROM_ASSIGNMENTS_IN_DESCRIPTIONS_RELATED_SCOPE.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IResourceAssignmentInResourceDescription> getFromAssignmentsInDescriptionsTargetScope() {
        return CICSRegionGroupDefinitionType.FROM_ASSIGNMENTS_IN_DESCRIPTIONS_TARGET_SCOPE.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IResourceDescriptionDefinition> getFromResourceDescription() {
        return CICSRegionGroupDefinitionType.FROM_RESOURCE_DESCRIPTION.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IWorkloadDefinition> getFromWorkloadDefinitions() {
        return CICSRegionGroupDefinitionType.FROM_WORKLOAD_DEFINITIONS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IWorkloadSpecification> getFromWorkloadSpecifications() {
        return CICSRegionGroupDefinitionType.FROM_WORKLOAD_SPECIFICATIONS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

