/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ResourceGroupDefinitionReference;
import com.ibm.cics.core.model.ResourceGroupDefinitionType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IResourceAssignmentDefinition;
import com.ibm.cics.model.IResourceAssignmentInResourceDescription;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.model.IResourceGroupEntry;
import com.ibm.cics.model.IResourceInDescriptionEntry;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableResourceGroupDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableResourceGroupDefinition
extends MutableCPSMDefinition
implements IMutableResourceGroupDefinition {
    private IResourceGroupDefinition delegate;
    private MutableSMRecord record;

    public MutableResourceGroupDefinition(ICPSM cpsm, IContext context, IResourceGroupDefinition cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("RESGROUP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)ResourceGroupDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESCRIPTION", null);
        } else {
            ResourceGroupDefinitionType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)ResourceGroupDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESCRIPTION", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ResourceGroupDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ResourceGroupDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        return super.getAttributeValue(attribute);
    }

    public ResourceGroupDefinitionType getObjectType() {
        return ResourceGroupDefinitionType.getInstance();
    }

    @Override
    public ResourceGroupDefinitionReference getCICSObjectReference() {
        return new ResourceGroupDefinitionReference(this.getCICSContainer(), this.getName());
    }

    public ICICSObjectSet<IResourceAssignmentDefinition> getFromResourceAssignments() {
        return ResourceGroupDefinitionType.FROM_RESOURCE_ASSIGNMENTS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IResourceAssignmentInResourceDescription> getFromAssignmentsInDescriptions() {
        return ResourceGroupDefinitionType.FROM_ASSIGNMENTS_IN_DESCRIPTIONS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IResourceInDescriptionEntry> getGroupsInDescriptions() {
        return ResourceGroupDefinitionType.GROUPS_IN_DESCRIPTIONS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IResourceGroupEntry> getResourcesInGroup() {
        return ResourceGroupDefinitionType.RESOURCES_IN_GROUP.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

