/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.ISystemManagerConnection2;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.TypeNotFoundException;
import com.ibm.cics.sm.comm.sm.SMConnectionException;
import com.ibm.cics.sm.comm.sm.SMResponse;
import com.ibm.cics.sm.comm.sm.internal.RequestBuilder;
import com.ibm.cics.sm.comm.sm.internal.SMCICSConnection;
import com.ibm.cics.sm.comm.sm.internal.VSE51ConnectionBehaviour;
import com.ibm.cics.sm.comm.sm.internal.VSE61ConnectionBehaviour;
import com.ibm.cics.sm.comm.sm.internal.VSE62ConnectionBehaviour;
import com.ibm.cics.sm.comm.sm.internal.VSEConnectionBehaviour;

public class SMVSEConnection
extends SMCICSConnection
implements ISystemManagerConnection2 {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SMVSEConnection.class);
    private static final String CICSRGN_ATTRIBUTE_CICSREL = "EYU_CICSREL";
    private static final String VSE_CICSREL_PREFIX = "V";
    protected static final String VSE_111_EYU_CICSREL = "V111";
    protected static final String VSE_420_EYU_CICSREL = "V420";
    protected static final String VSE_430_EYU_CICSREL = "V430";
    protected static final String CICS_TS_41_EYU_CICSREL = "040100";
    protected static final String CICS_TS_42_EYU_CICSREL = "040200";
    protected VSEConnectionBehaviour vseConnectionBehaviour = new VSEConnectionBehaviour();

    @Override
    protected String buildGETRequest(String resourceType, IContext context, boolean useCache) throws TypeNotFoundException {
        debug.enter("buildGETRequest", (Object)resourceType, (Object)context);
        String request = RequestBuilder.buildRequest(resourceType, context, false, false, false, true, true);
        debug.exit("buildGETRequest", (Object)request);
        return request;
    }

    @Override
    public SMResponse create(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        SMResponse response = super.create(resourceType, context, record);
        this.vseConnectionBehaviour.modifyRecords(response);
        return response;
    }

    @Override
    public SMResponse fetch(String stub, int position, int count) throws SystemManagerConnectionException, AuthenticationException {
        debug.enter("fetch", (Object)this, (Object)stub, (Object)position, (Object)count);
        SMResponse response = null;
        if (!stub.equals("CMASLIST")) {
            response = (SMResponse)((Object)this.stubs.get(stub));
            if (response != null) {
                String resourceType = response.getResourceType();
                if (response.getResponse().equals("NODATA")) {
                    response = SMResponse.noRecords(stub, resourceType, response.getContext());
                } else if (response.getRecordTotal() == 0) {
                    debug.event("fetch", (Object)response);
                    response = SMResponse.noRecords(stub, resourceType, null);
                } else {
                    response = response.subResponse(position - 1, count);
                    this.vseConnectionBehaviour.modifyRecords(response);
                }
            } else {
                throw new SMConnectionException(stub);
            }
        }
        debug.exit("fetch", response);
        return response;
    }

    @Override
    protected String getVersionFromRegionRecord() {
        debug.enter("getVersionFromRegionRecord");
        String release = this.regionRecord.get(CICSRGN_ATTRIBUTE_CICSREL);
        debug.event("getVersionFromRegionRecord", "EYU_CICSREL from CICS: " + release);
        if (release.equals(VSE_111_EYU_CICSREL)) {
            this.vseConnectionBehaviour = new VSE51ConnectionBehaviour();
            release = CICS_TS_41_EYU_CICSREL;
        } else if (release.equals(VSE_420_EYU_CICSREL)) {
            this.vseConnectionBehaviour = new VSE61ConnectionBehaviour();
            release = CICS_TS_42_EYU_CICSREL;
        } else if (release.equals(VSE_430_EYU_CICSREL)) {
            this.vseConnectionBehaviour = new VSE62ConnectionBehaviour();
            release = CICS_TS_42_EYU_CICSREL;
        } else {
            this.vseConnectionBehaviour = new VSEConnectionBehaviour();
        }
        debug.exit("getVersionFromRegionRecord", (Object)("Returning EYU_CICSREL: " + release));
        return release;
    }

    @Override
    public String getActions(String resourceName, IContext context) {
        debug.enter("getActions");
        String actions = this.vseConnectionBehaviour.getActions(resourceName, context);
        debug.exit("getActions", (Object)actions);
        return actions;
    }

    @Override
    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        debug.enter("checkOperation", (Object)this, (Object)resourceType, (Object)context, (Object)operation);
        boolean supported = this.vseConnectionBehaviour.checkOperation(resourceType, context, operation);
        if (supported) {
            switch (operation.getOperationType()) {
                case GET: {
                    supported = this.checkGetOperation(resourceType, context, operation);
                    break;
                }
                case PERFORM: {
                    supported = super.checkOperation(resourceType, context, operation);
                    break;
                }
            }
        }
        debug.exit("checkOperation", (Object)supported);
        return supported;
    }

    @Override
    public void discard(String stub) throws SMConnectionException {
        debug.enter("discard", (Object)this, (Object)stub);
        SMResponse smResponse = (SMResponse)((Object)this.stubs.remove(stub));
        debug.event("discard", (Object)smResponse);
        debug.exit("discard");
    }

    private boolean checkGetOperation(String resourceType, IContext context, ICICSOperation operation) {
        if (this.vseConnectionBehaviour.isGetOperationSupportedByVSE(resourceType, context, operation, IResourceTables.Helper.isCICSDefinition((String)resourceType))) {
            return super.checkOperation(resourceType, context, operation);
        }
        return false;
    }

    public static boolean isVSEConnection(SMConnectionRecord regionRecord) {
        String cicsrel = regionRecord.get(CICSRGN_ATTRIBUTE_CICSREL);
        return cicsrel.startsWith(VSE_CICSREL_PREFIX);
    }

    @Override
    protected void checkVSEConnection() throws SMConnectionException {
        if (!SMVSEConnection.isVSEConnection(this.regionRecord)) {
            debug.event("checkForVSEConnection", "VSE connection attempted on non-VSE region data");
            throw new SMConnectionException("Unexpected VSE Connection attempt");
        }
    }
}

