/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArrayValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.BooleanValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.DocumentAppender;
import com.ibm.cics.sm.comm.sm.internal.graphql.DocumentContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.DoubleValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.FieldParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.LongValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.ObjectValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.StringBuilderAppender;
import com.ibm.cics.sm.comm.sm.internal.graphql.StringValueParser;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ObjectContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final MutableAppender contents;
    private boolean requiresSpace = false;
    private DocumentContext.FragmentRegistry fragmentRegistry;
    private boolean mute;

    public ObjectContext(DocumentAppender contents, DocumentContext.FragmentRegistry fragmentRegistry, Consumer<ObjectContext> queryWriter) {
        this.contents = new MutableAppender(contents);
        this.fragmentRegistry = fragmentRegistry;
        contents.append('{');
        queryWriter.accept(this);
        contents.append('}');
    }

    private <NT, N extends Node<NT>> void subContext(N node, Consumer<? super N> query) {
        new ObjectContext(this.contents, this.fragmentRegistry, oc -> {
            node.setObjectContext((ObjectContext)oc);
            query.accept((Object)node);
        });
        if (!this.mute) {
            this.requiresSpace = false;
        }
    }

    private void unionTypeContext(List<NodeQueryTuple<?, ?>> nodeQueries) {
        new ObjectContext(this.contents, this.fragmentRegistry, oc -> {
            oc.writeField("__typename");
            nodeQueries.forEach(nodeQuery -> {
                oc.writeField("... on " + ((NodeQueryTuple)nodeQuery).node.getGraphQLTypeName());
                ObjectContext.applyUnionFragment(oc, nodeQuery);
            });
        });
        if (!this.mute) {
            this.requiresSpace = false;
        }
    }

    private static <NT, N extends Node<NT>> void applyUnionFragment(ObjectContext oc, NodeQueryTuple<NT, N> nodeQuery) {
        oc.subContext(((NodeQueryTuple)nodeQuery).node, ((NodeQueryTuple)nodeQuery).query);
    }

    public NodeParser<Optional<String>> stringField(String name) {
        this.writeField(name);
        return new FieldParser<String>(name, new StringValueParser());
    }

    public <NT, N extends Node<NT>> NodeParser<Optional<UnionResult>> unionObjectField(String name, List<NodeQueryTuple<?, ?>> nodeQueries) {
        this.writeField(name);
        this.unionTypeContext(nodeQueries);
        return new FieldParser<UnionResult>(name, new ObjectValueParser<UnionResult>(o -> {
            if (!o.has("__typename")) throw new NodeParseRuntimeException("__typename property was missing from union type result");
            JsonElement typename = o.get("__typename");
            if (!typename.isJsonPrimitive()) throw new NodeParseRuntimeException("__typename property on union result wasn't a string");
            JsonPrimitive typenamePrimitive = typename.getAsJsonPrimitive();
            if (!typenamePrimitive.isString()) {
                throw new NodeParseRuntimeException("__typename property on union result wasn't a string");
            }
            String typeName = typenamePrimitive.getAsString();
            Map nodesByTypeName = nodeQueries.stream().collect(Collectors.toMap(nodeQuery -> ((NodeQueryTuple)nodeQuery).node.getGraphQLTypeName(), Function.identity()));
            NodeQueryTuple nodeQuery2 = (NodeQueryTuple)nodesByTypeName.get(typeName);
            if (nodeQuery2 != null) return UnionResult.parseFrom(nodeQuery2.node, o);
            throw new NodeParseRuntimeException("Unexpected __typename returned for union query: " + typeName);
        }));
    }

    public <NT, N extends Node<NT>> NodeParser<Optional<NT>> objectField(String name, Consumer<ArgumentsContext> args, N node, Consumer<? super N> query) {
        this.writeField(name);
        FieldParser parser = new FieldParser(name, new ObjectValueParser(node));
        this.appendArgs(args);
        this.subContext(node, query);
        return parser;
    }

    public NodeParser<Optional<Long>> longField(String name) {
        this.writeField(name);
        return new FieldParser<Long>(name, new LongValueParser());
    }

    public NodeParser<Optional<Double>> doubleField(String name) {
        this.writeField(name);
        return new FieldParser<Double>(name, new DoubleValueParser());
    }

    public NodeParser<Optional<Boolean>> booleanField(String name) {
        this.writeField(name);
        return new FieldParser<Boolean>(name, new BooleanValueParser());
    }

    public <NT, N extends Node<NT>> NodeParser<Optional<List<NT>>> arrayFieldNonNullValues(String name, Consumer<ArgumentsContext> args, N node, Consumer<? super N> query) {
        this.writeField(name);
        this.appendArgs(args);
        FieldParser<List<NT>> fieldParser = new FieldParser<List<NT>>(name, ArrayValueParser.nonNullValues(new ObjectValueParser(node)));
        this.subContext(node, query);
        return fieldParser;
    }

    public <NT, N extends Node<NT>> NodeParser<Optional<List<Optional<NT>>>> arrayFieldNullableValues(String name, Consumer<ArgumentsContext> args, N node, Consumer<? super N> query) {
        this.writeField(name);
        this.appendArgs(args);
        FieldParser fieldParser = new FieldParser(name, ArrayValueParser.nullableValues(new ObjectValueParser(node)));
        this.subContext(node, query);
        return fieldParser;
    }

    private void appendArgs(Consumer<ArgumentsContext> args) {
        if (args != null) {
            StringBuilderAppender appender = new StringBuilderAppender();
            args.accept(new ArgumentsContext(appender));
            String argsString = appender.toString();
            if (argsString.length() > 0) {
                this.contents.append('(');
                this.contents.append(argsString);
                this.contents.append(')');
            }
        }
    }

    private void writeField(CharSequence name) {
        if (this.requiresSpace) {
            this.contents.append(' ');
        }
        if (!this.mute) {
            this.requiresSpace = true;
        }
        this.contents.append(name);
    }

    public <NT, N extends Node<NT>> void fragmentReference(String id, N node) {
        try {
            this.mute = true;
            this.fragmentRegistry.applyFragment(id, node);
        }
        finally {
            this.mute = false;
        }
        this.writeField("..." + id);
    }

    private class MutableAppender
    implements DocumentAppender {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private DocumentAppender delegate;

        public MutableAppender(DocumentAppender delegate) {
            this.delegate = delegate;
        }

        @Override
        public DocumentAppender append(CharSequence csq) {
            if (!ObjectContext.this.mute) {
                this.delegate.append(csq);
            }
            return this;
        }

        @Override
        public DocumentAppender append(char c) {
            if (!ObjectContext.this.mute) {
                this.delegate.append(c);
            }
            return this;
        }

        @Override
        public DocumentAppender append(long value) {
            if (!ObjectContext.this.mute) {
                this.delegate.append(value);
            }
            return this;
        }
    }

    public static class NodeQueryTuple<NT, N extends Node<NT>> {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private final N node;
        private final Consumer<? super N> query;

        public NodeQueryTuple(N node, Consumer<? super N> query) {
            this.node = node;
            this.query = query;
        }
    }

    public static class UnionResult {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private final Node<?> node;
        private final Object result;

        private <NT> UnionResult(Node<NT> node, NT result) {
            this.node = node;
            this.result = result;
        }

        private static <NT> UnionResult parseFrom(Node<NT> node, JsonObject o) throws NodeParseRuntimeException {
            return new UnionResult(node, node.parse(o));
        }

        public <NT> Optional<NT> getResult(Node<NT> node) {
            if (node == this.node) {
                return Optional.ofNullable(this.result);
            }
            return Optional.empty();
        }
    }
}

