/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.ApplicationDefinitionReference;
import com.ibm.cics.core.model.ApplicationDefinitionType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IPlatformDefinitionReference;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableApplicationDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableApplicationDefinition
extends MutableCPSMDefinition
implements IMutableApplicationDefinition {
    private IApplicationDefinition delegate;
    private MutableSMRecord record;

    public MutableApplicationDefinition(ICPSM cpsm, IContext context, IApplicationDefinition cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("APPLDEF");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)ApplicationDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public String getPlatformDefinition() {
        return this.delegate.getPlatformDefinition();
    }

    public String getApplicationDirectory() {
        return this.delegate.getApplicationDirectory();
    }

    public Long getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public Long getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public Long getMicroVersion() {
        return this.delegate.getMicroVersion();
    }

    public String getBindingDirectory() {
        String result = this.record.get("BINDDIR");
        if (result == null) {
            return this.delegate.getBindingDirectory();
        }
        return (String)((CICSAttribute)ApplicationDefinitionType.BINDING_DIRECTORY).get(result, this.record.getNormalizers());
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESCRIPTION", null);
        } else {
            ApplicationDefinitionType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)ApplicationDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESCRIPTION", connectionSpecificExternalValue);
        }
    }

    public void setBindingDirectory(String _bindingDirectory) {
        if (_bindingDirectory.equals(this.delegate.getBindingDirectory())) {
            this.record.set("BINDDIR", null);
        } else {
            ApplicationDefinitionType.BINDING_DIRECTORY.validate((Object)_bindingDirectory);
            String connectionSpecificExternalValue = ((CICSAttribute)ApplicationDefinitionType.BINDING_DIRECTORY).set(_bindingDirectory, this.record.getNormalizers());
            this.record.set("BINDDIR", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ApplicationDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ApplicationDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == ApplicationDefinitionType.PLATFORM_DEFINITION) {
            return (V)this.getPlatformDefinition();
        }
        if (attribute == ApplicationDefinitionType.APPLICATION_DIRECTORY) {
            return (V)this.getApplicationDirectory();
        }
        if (attribute == ApplicationDefinitionType.MAJOR_VERSION) {
            return (V)this.getMajorVersion();
        }
        if (attribute == ApplicationDefinitionType.MINOR_VERSION) {
            return (V)this.getMinorVersion();
        }
        if (attribute == ApplicationDefinitionType.MICRO_VERSION) {
            return (V)this.getMicroVersion();
        }
        if (attribute == ApplicationDefinitionType.BINDING_DIRECTORY) {
            return (V)this.getBindingDirectory();
        }
        return super.getAttributeValue(attribute);
    }

    public ApplicationDefinitionType getObjectType() {
        return ApplicationDefinitionType.getInstance();
    }

    @Override
    public ApplicationDefinitionReference getCICSObjectReference() {
        return new ApplicationDefinitionReference(this.getCICSContainer(), this.getName(), this.getMajorVersion(), this.getMinorVersion(), this.getMicroVersion(), this.getPlatformDefinition());
    }

    public IPlatformDefinitionReference getPlatformDefinitionReference() {
        return (IPlatformDefinitionReference)ApplicationDefinitionType.PLATFORM_DEFINITION_REFERENCE.getTo((ICICSObject)this);
    }
}

