/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadDefinitionReference;
import com.ibm.cics.core.model.WorkloadDefinitionType;
import com.ibm.cics.core.model.internal.CPSMDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSRegionDefinitionReference;
import com.ibm.cics.model.ICICSRegionGroupDefinitionReference;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.ITransactionGroupReference;
import com.ibm.cics.model.IWorkloadDefinition;
import com.ibm.cics.model.IWorkloadDefinitionInWorkloadGroup;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class WorkloadDefinition
extends CPSMDefinition
implements IWorkloadDefinition {
    private String _name;
    private String _trangrp;
    private String _luname;
    private String _userid;
    private String _aorscope;
    private String _processtype;
    private String _desc;

    public WorkloadDefinition(ICPSMDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._name = (String)avm.getAttributeValue(WorkloadDefinitionType.NAME);
        this._trangrp = (String)avm.getAttributeValue(WorkloadDefinitionType.TRANSACTION_GROUP, true);
        this._luname = (String)avm.getAttributeValue(WorkloadDefinitionType.LU_NAME, true);
        this._userid = (String)avm.getAttributeValue(WorkloadDefinitionType.USER_ID, true);
        this._aorscope = (String)avm.getAttributeValue(WorkloadDefinitionType.TARGET_SCOPE, true);
        this._processtype = (String)avm.getAttributeValue(WorkloadDefinitionType.PROCESS_TYPE, true);
        this._desc = (String)avm.getAttributeValue(WorkloadDefinitionType.DESCRIPTION, true);
    }

    public WorkloadDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)WorkloadDefinitionType.NAME).get(stringValue, normalizers);
        stringValue = record.get("TRANGRP");
        this._trangrp = (String)((CICSAttribute)WorkloadDefinitionType.TRANSACTION_GROUP).get(stringValue, normalizers);
        stringValue = record.get("LUNAME");
        this._luname = (String)((CICSAttribute)WorkloadDefinitionType.LU_NAME).get(stringValue, normalizers);
        stringValue = record.get("USERID");
        this._userid = (String)((CICSAttribute)WorkloadDefinitionType.USER_ID).get(stringValue, normalizers);
        stringValue = record.get("AORSCOPE");
        this._aorscope = (String)((CICSAttribute)WorkloadDefinitionType.TARGET_SCOPE).get(stringValue, normalizers);
        stringValue = record.get("PROCESSTYPE");
        this._processtype = (String)((CICSAttribute)WorkloadDefinitionType.PROCESS_TYPE).get(stringValue, normalizers);
        stringValue = record.get("DESC");
        this._desc = (String)((CICSAttribute)WorkloadDefinitionType.DESCRIPTION).get(stringValue, normalizers);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getTransactionGroup() {
        return this._trangrp;
    }

    public String getLuName() {
        return this._luname;
    }

    public String getUserId() {
        return this._userid;
    }

    public String getTargetScope() {
        return this._aorscope;
    }

    public String getProcessType() {
        return this._processtype;
    }

    public String getDescription() {
        return this._desc;
    }

    public WorkloadDefinitionType getObjectType() {
        return WorkloadDefinitionType.getInstance();
    }

    @Override
    public WorkloadDefinitionReference getCICSObjectReference() {
        return new WorkloadDefinitionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == WorkloadDefinitionType.TRANSACTION_GROUP) {
            return (V)this.getTransactionGroup();
        }
        if (attribute == WorkloadDefinitionType.LU_NAME) {
            return (V)this.getLuName();
        }
        if (attribute == WorkloadDefinitionType.USER_ID) {
            return (V)this.getUserId();
        }
        if (attribute == WorkloadDefinitionType.TARGET_SCOPE) {
            return (V)this.getTargetScope();
        }
        if (attribute == WorkloadDefinitionType.PROCESS_TYPE) {
            return (V)this.getProcessType();
        }
        if (attribute == WorkloadDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        return super.getAttributeValue(attribute);
    }

    public ITransactionGroupReference getTransactionGroupReference() {
        return (ITransactionGroupReference)WorkloadDefinitionType.TRANSACTION_GROUP_REFERENCE.getTo((ICICSObject)this);
    }

    public ICICSRegionGroupDefinitionReference getRegionGroupDefinitionReference() {
        return (ICICSRegionGroupDefinitionReference)WorkloadDefinitionType.REGION_GROUP_DEFINITION_REFERENCE.getTo((ICICSObject)this);
    }

    public ICICSRegionDefinitionReference getRegionDefinitionReference() {
        return (ICICSRegionDefinitionReference)WorkloadDefinitionType.REGION_DEFINITION_REFERENCE.getTo((ICICSObject)this);
    }

    public ICICSObjectSet<IWorkloadDefinitionInWorkloadGroup> getGroupMemberships() {
        return WorkloadDefinitionType.GROUP_MEMBERSHIPS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

