/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ManagementPartType;
import com.ibm.cics.core.ui.internal.cloud.AbstractManagementPartNodeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionGroupDefinition;

public class ApplicationManagementPartNodeDeferredWorkbenchAdapter
extends AbstractManagementPartNodeDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICICSRegionGroupDefinition regionType;
    private IApplication application;

    public ApplicationManagementPartNodeDeferredWorkbenchAdapter(CloudInput anInput, ICICSRegionGroupDefinition aRegionType, IApplication anApplication) {
        super(anInput);
        this.regionType = aRegionType;
        this.application = anApplication;
    }

    @Override
    protected FilteredContext getFilteredContext() {
        FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), ManagementPartType.REGION_TYPE, this.regionType.getRegiontype());
        filteredContext.setAttributeValue(ManagementPartType.PLATFORM_DEFINITION_NAME, (Object)this.application.getPlatformDefinitionName());
        filteredContext.setAttributeValue(ManagementPartType.APPLICATION_DEFINITION_NAME, (Object)this.application.getApplicationDefinitionName());
        filteredContext.setAttributeValue(ManagementPartType.APPLICATION_MAJOR_VERSION, (Object)this.application.getMajorVersion());
        filteredContext.setAttributeValue(ManagementPartType.APPLICATION_MINOR_VERSION, (Object)this.application.getMinorVersion());
        filteredContext.setAttributeValue(ManagementPartType.APPLICATION_MICRO_VERSION, (Object)this.application.getMicroVersion());
        return filteredContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.application == null ? 0 : this.application.hashCode());
        result = 31 * result + (this.regionType == null ? 0 : this.regionType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationManagementPartNodeDeferredWorkbenchAdapter other = (ApplicationManagementPartNodeDeferredWorkbenchAdapter)obj;
        if (this.application == null ? other.application != null : !EqualityHelper.equals((ICICSObject)this.application, (ICICSObject)other.application)) {
            return false;
        }
        return !(this.regionType == null ? other.regionType != null : !EqualityHelper.equals((ICICSObject)this.regionType, (ICICSObject)other.regionType));
    }
}

