/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.core.model.ManagedRegionType;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class PlatformManagedRegionNodeDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(PlatformManagedRegionNodeDeferredWorkbenchAdapter.class);
    private final ICICSRegionGroupDefinition regionType;

    public PlatformManagedRegionNodeDeferredWorkbenchAdapter(CloudInput anInput, ICICSRegionGroupDefinition aRegionType) {
        super(anInput);
        this.regionType = aRegionType;
    }

    @Override
    public Object[] getDataChildren(Object inputElement) {
        DEBUG.enter("getDataChildren", (Object)this, inputElement);
        Object[] result = new Object[]{};
        try {
            ICICSObject[] managedRegions = this.getCPSM().getDefinitions2((ICICSType)ManagedRegionType.getInstance(), (IContext)new ScopedContext(this.getCloudInput().getCICSPlexName(), this.regionType.getName()));
            DEBUG.event("getDataChildren", String.valueOf(managedRegions.length) + " regions");
            result = new Object[managedRegions.length];
            System.arraycopy(managedRegions, 0, result, 0, managedRegions.length);
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() != null && !(e.getCause() instanceof SystemManagerConnectionException)) {
                DEBUG.event("getDataChildren", (Object)e);
                result = new Object[]{new ErrorWrapper(e.getCause())};
            }
            DEBUG.error("getDataChildren", (Throwable)e);
        }
        DEBUG.exit("getDataChildren", (Object)result);
        return result;
    }

    public boolean isContainer() {
        DEBUG.enter("isContainer", (Object)this);
        boolean result = true;
        DEBUG.exit("isContainer", (Object)result);
        return result;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        DEBUG.enter("getImageDescriptor", (Object)this, object);
        ImageDescriptor result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        DEBUG.exit("getImageDescriptor", (Object)result);
        return result;
    }

    public String getLabel(Object o) {
        DEBUG.enter("getLabel", (Object)this, o);
        String result = NLS.bind((String)CloudMessages.RegionsNodeName, null);
        DEBUG.exit("getLabel", (Object)result);
        return result;
    }

    @Override
    public String getDecorateText(IDecorationContext context) {
        return "";
    }

    @Override
    protected String getFetchingName() {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.regionType == null ? 0 : this.regionType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformManagedRegionNodeDeferredWorkbenchAdapter other = (PlatformManagedRegionNodeDeferredWorkbenchAdapter)obj;
        return !(this.regionType == null ? other.regionType != null : !EqualityHelper.equals((ICICSObject)this.regionType, (ICICSObject)other.regionType));
    }
}

