/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.ui.views.FilterManager;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.ResourcesTable;
import com.ibm.cics.explorer.tables.ui.IBaseContextProvider;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ResourcesTableSelectionDialog
extends SelectionStatusDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ResourcesTable resourcesTable;
    private IWorkbenchPartSite parentSite;

    public ResourcesTableSelectionDialog(Shell parentShell, String title, IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider, String connectionCategory, boolean multiSelect, IWorkbenchPartSite parentSite) {
        super(parentShell);
        this.setTitle(title);
        this.resourcesTable = new ResourcesTable(elementTypeService, defaultColumnsProvider, connectionCategory, multiSelect);
        this.parentSite = parentSite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        ToolBar toolBar = new ToolBar(dialogArea, 0);
        toolBar.setLayoutData((Object)GridDataFactory.swtDefaults().align(131072, 0x1000000).create());
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        MenuManager menuManager = new MenuManager();
        menuManager.createContextMenu((Control)dialogArea);
        this.resourcesTable.init(this.parentSite, (IToolBarManager)toolBarManager, (IMenuManager)menuManager, null, true);
        this.resourcesTable.createControl(dialogArea);
        this.resourcesTable.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourcesTableSelectionDialog.this.updateStatusFromSelection(event.getSelection());
            }
        });
        this.resourcesTable.getFilterManager().addListener(new FilterManager.FilterListener(){

            public void event(FilterManager.FilterEvent event) {
                if (event instanceof FilterManager.FilterChangedEvent) {
                    ResourcesTableSelectionDialog.this.updateStatusFromSelection(ResourcesTableSelectionDialog.this.resourcesTable.getTableViewer().getSelection());
                }
            }
        });
        Composite resourcesTableComposite = this.resourcesTable.getComposite();
        resourcesTableComposite.setLayoutData((Object)GridDataFactory.createFrom((GridData)((GridData)resourcesTableComposite.getLayoutData())).hint(500, 400).create());
        toolBarManager.add((IAction)new DropDownAction(menuManager));
        toolBarManager.update(true);
        this.resourcesTable.opened();
        this.resourcesTable.visible(true);
        this.resourcesTable.maybeSetInput();
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateStatusFromSelection(this.resourcesTable.getTableViewer().getSelection());
        return control;
    }

    protected void updateStatusFromSelection(ISelection selection) {
        boolean valid = !selection.isEmpty();
        this.updateStatus(valid ? ValidationStatus.ok() : ValidationStatus.cancel((String)Messages.getString("ResourcesTableSelectionDialog.noSelectionMessage", new Object[0])));
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!status.matches(12));
        }
    }

    public void setBaseContextProvider(IBaseContextProvider provider) {
        this.resourcesTable.setBaseContextProvider(provider);
    }

    protected void computeResult() {
        this.setResult(((IStructuredSelection)this.resourcesTable.getTableViewer().getSelection()).toList());
    }

    private static class DropDownAction
    extends Action
    implements IMenuCreator {
        private MenuManager menuManager;

        public DropDownAction(MenuManager menuManager) {
            super("", 4);
            this.menuManager = menuManager;
            this.setMenuCreator(this);
        }

        public void dispose() {
            this.menuManager.dispose();
        }

        public Menu getMenu(Control parent) {
            return this.menuManager.getMenu();
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }
}

