/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model.query;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.CICSObjectAggregateRecord;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSDefinitionType;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSResourceType;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.ICPSMDefinitionType;
import com.ibm.cics.model.ICPSMManager;
import com.ibm.cics.model.ICPSMManagerType;
import com.ibm.cics.model.query.CICSDefinitionsQuery;
import com.ibm.cics.model.query.CICSObjectRecordsQuery;
import com.ibm.cics.model.query.CICSObjectRecordsQueryResult;
import com.ibm.cics.model.query.CICSResourcesQuery;
import com.ibm.cics.model.query.CICSplexQuery;
import com.ibm.cics.model.query.CICSplexQueryResult;
import com.ibm.cics.model.query.CPSMDefinitionsQuery;
import com.ibm.cics.model.query.CPSMManagersQuery;
import com.ibm.cics.model.query.CSDQuery;
import com.ibm.cics.model.query.CSDQueryResult;
import com.ibm.cics.model.query.DREPQuery;
import com.ibm.cics.model.query.DREPQueryResult;
import com.ibm.cics.model.query.DateAggregationQuery;
import com.ibm.cics.model.query.EnumAggregationQuery;
import com.ibm.cics.model.query.EnumAggregationValueQuery;
import com.ibm.cics.model.query.LongAggregationQuery;
import com.ibm.cics.model.query.Query;
import com.ibm.cics.model.query.QueryResult;
import com.ibm.cics.model.query.QueryValidationException;
import com.ibm.cics.model.query.RegionGroupQuery;
import com.ibm.cics.model.query.RegionGroupQueryResult;
import com.ibm.cics.model.query.RegionQuery;
import com.ibm.cics.model.query.RegionQueryResult;
import com.ibm.cics.model.query.Request;
import com.ibm.cics.model.query.StringAggregationQuery;
import com.ibm.cics.model.topology.CPSM;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryBuilder<Req, Res> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(QueryBuilder.class);
    private final BiConsumer<Request, Consumer<Req>> query;
    private final Function<QueryResult, Res> parser;
    public static final QueryUnit<RegionQuery, RegionQueryResult, CICSResourcesQuery, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult>> REGION_CICS_RESOURCES = new QueryUnit(RegionQuery::cicsResources, RegionQueryResult::getCICSResources);
    public static final QueryUnit<RegionGroupQuery, RegionGroupQueryResult, CICSResourcesQuery, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult>> REGION_GROUP_CICS_RESOURCES = new QueryUnit(RegionGroupQuery::cicsResources, RegionGroupQueryResult::getCICSResources);
    public static final QueryUnit<CICSplexQuery, CICSplexQueryResult, CICSResourcesQuery, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult>> CICSPLEX_CICS_RESOURCES = new QueryUnit(CICSplexQuery::cicsResources, CICSplexQueryResult::getCICSResources);
    public static final QueryUnit<CICSplexQuery, CICSplexQueryResult, CPSMManagersQuery, Map<ICICSType<? extends ICPSMManager>, CICSObjectRecordsQueryResult>> CICSPLEX_CPSM_MANAGERS = new QueryUnit(CICSplexQuery::cpsmManagers, CICSplexQueryResult::getCPSMManagers);
    public static final QueryUnit<CICSplexQuery, CICSplexQueryResult, DREPQuery, DREPQueryResult> CICSPLEX_DREP = new QueryUnit(CICSplexQuery::drep, cpr -> cpr.getDREPResult().orElseThrow(() -> new QueryParseException("Couldn't get DREP result")));
    public static final QueryUnit<RegionQuery, RegionQueryResult, CSDQuery, CSDQueryResult> REGION_CSD = new QueryUnit(RegionQuery::csd, rqr -> rqr.getCSDResult().orElseThrow(() -> new QueryParseException("Couldn't get CSD result")));
    public static final QueryUnit<CSDQuery, CSDQueryResult, CICSDefinitionsQuery, Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult>> CSD_CICS_DEFINITIONS = new QueryUnit(CSDQuery::cicsDefinitions, CSDQueryResult::getCICSDefinitions);
    public static final QueryUnit<DREPQuery, DREPQueryResult, CPSMDefinitionsQuery, Map<ICICSType<? extends ICPSMDefinition>, CICSObjectRecordsQueryResult>> DREP_CPSM_DEFINITIONS = new QueryUnit(DREPQuery::cpsmDefinitions, DREPQueryResult::getCPSMDefinitions);
    public static final QueryUnit<DREPQuery, DREPQueryResult, CICSDefinitionsQuery, Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult>> DREP_CICS_DEFINITIONS = new QueryUnit(DREPQuery::cicsDefinitions, DREPQueryResult::getCICSDefinitions);
    private static final Consumer<StringAggregationQuery> STRING_AGGREGATION_QUERY = sAQ -> {
        StringAggregationQuery stringAggregationQuery = sAQ.value().distinctValues().unsupported();
    };
    private static final Consumer<LongAggregationQuery> LONG_AGGREGATION_QUERY = lAQ -> {
        LongAggregationQuery longAggregationQuery = lAQ.average().difference().distinctValues().max().metaValueCounts().min().sum().unspecified().unsupported();
    };
    private static final Consumer<DateAggregationQuery> DATE_AGGREGATION_QUERY = dAQ -> {
        DateAggregationQuery dateAggregationQuery = dAQ.average().distinctValues().max().min().unspecified().unsupported();
    };
    private static final Consumer<EnumAggregationQuery> ENUM_AGGREGATION_QUERY = eAQ -> {
        EnumAggregationQuery enumAggregationQuery = eAQ.unspecified().unsupported().values(eAVQ -> {
            EnumAggregationValueQuery enumAggregationValueQuery = eAVQ.count().value();
        });
    };

    private QueryBuilder(BiConsumer<Request, Consumer<Req>> query, Function<QueryResult, Res> parser) {
        this.query = query;
        this.parser = parser;
    }

    public <ReqX, ResX> QueryBuilder<ReqX, ResX> next(QueryUnit<Req, Res, ReqX, ResX> next) {
        return new QueryBuilder<Req, Object>((request, reqX) -> this.query.accept((Request)request, req -> next.query.accept(req, reqX)), qr -> next.parser.apply(this.parser.apply((QueryResult)qr)));
    }

    public Res run(CPSM cpsm) throws CICSActionException {
        QueryResult result = cpsm.graphQuery(request -> this.query.accept((Request)request, req -> {}));
        try {
            return this.parser.apply(result);
        }
        catch (QueryParseException e) {
            throw new CICSActionException("An error occurred parsing the query response", e);
        }
    }

    public static <ReqX, ResX> QueryBuilder<ReqX, ResX> start(QueryUnit<Request, QueryResult, ReqX, ResX> next) {
        return new QueryBuilder(((QueryUnit)next).query, ((QueryUnit)next).parser);
    }

    public static QueryUnit<Request, QueryResult, CICSplexQuery, CICSplexQueryResult> cicsplex(String name) {
        return new QueryUnit<Request, QueryResult, CICSplexQuery, CICSplexQueryResult>((r, cpq) -> {
            Request request = r.query("aggregation", q -> {
                Query query = q.cicsplex(name, cpq.andThen(CICSplexQuery::name));
            });
        }, qr -> qr.getCICSplexResult().orElseThrow(() -> new QueryParseException("CICSplex " + name + " wasn't found")));
    }

    public static QueryUnit<CICSplexQuery, CICSplexQueryResult, RegionQuery, RegionQueryResult> region(String name) {
        return new QueryUnit<CICSplexQuery, CICSplexQueryResult, RegionQuery, RegionQueryResult>((cpq, rq) -> {
            CICSplexQuery cICSplexQuery = cpq.region(name, rq.andThen(RegionQuery::name));
        }, cpr -> cpr.getRegionResult().orElseThrow(() -> new QueryParseException("Region " + name + " wasn't found")));
    }

    public static QueryUnit<CICSplexQuery, CICSplexQueryResult, RegionGroupQuery, RegionGroupQueryResult> regionGroup(String name) {
        return new QueryUnit<CICSplexQuery, CICSplexQueryResult, RegionGroupQuery, RegionGroupQueryResult>((cpq, rgq) -> {
            CICSplexQuery cICSplexQuery = cpq.regionGroup(name, rgq.andThen(RegionGroupQuery::name));
        }, cpr -> cpr.getRegionGroupResult().orElseThrow(() -> new QueryParseException("Region group " + name + " wasn't found")));
    }

    public static QueryUnit<CICSplexQuery, CICSplexQueryResult, CICSResourcesQuery, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult>> unknownScope(String scope) {
        return new QueryUnit<CICSplexQuery, CICSplexQueryResult, CICSResourcesQuery, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult>>((cpq, crq) -> cpq.region(scope, r -> {
            RegionQuery regionQuery = r.name().cicsResources((Consumer<CICSResourcesQuery>)crq);
        }).regionGroup(scope, rg -> {
            RegionGroupQuery regionGroupQuery = rg.name().cicsResources((Consumer<CICSResourcesQuery>)crq);
        }), cpr -> {
            Optional<RegionQueryResult> regionResult = cpr.getRegionResult();
            Optional<RegionGroupQueryResult> regionGroupResult = cpr.getRegionGroupResult();
            if (regionResult.isPresent()) {
                return regionResult.get().getCICSResources();
            }
            if (regionGroupResult.isPresent()) {
                return regionGroupResult.get().getCICSResources();
            }
            throw new QueryParseException("Couldn't find a region or region group for scope " + scope + ".");
        });
    }

    public static <T extends ICICSResource> QueryUnit<CICSResourcesQuery, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>> cicsResource(ICICSResourceType<T> type, FilterExpression filter) {
        return new QueryUnit<CICSResourcesQuery, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>>((cicsrq, cicsorq) -> {
            CICSResourcesQuery cICSResourcesQuery = cicsrq.cicsResource(type, filter, cicsorq);
        }, map -> Optional.ofNullable((CICSObjectRecordsQueryResult)map.get(type)).map(Stream::of).orElseThrow(() -> new QueryParseException("CICS resource " + type.getResourceTableName() + " results weren't found")));
    }

    public static <T extends ICICSDefinition> QueryUnit<CICSDefinitionsQuery, Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>> cicsDefinition(ICICSDefinitionType<T> type, FilterExpression filter) {
        return new QueryUnit<CICSDefinitionsQuery, Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>>((cicsdq, cicsorq) -> {
            CICSDefinitionsQuery cICSDefinitionsQuery = cicsdq.cicsDefinition(type, filter, cicsorq);
        }, map -> Optional.ofNullable((CICSObjectRecordsQueryResult)map.get(type)).map(Stream::of).orElseThrow(() -> new QueryParseException("CICS definition " + type.getResourceTableName() + " results weren't found")));
    }

    public static <T extends ICPSMDefinition> QueryUnit<CPSMDefinitionsQuery, Map<ICICSType<? extends ICPSMDefinition>, CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>> cpsmDefinition(ICPSMDefinitionType<T> type, FilterExpression filter) {
        return new QueryUnit<CPSMDefinitionsQuery, Map<ICICSType<? extends ICPSMDefinition>, CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>>((cpsmdq, cicsorq) -> {
            CPSMDefinitionsQuery cPSMDefinitionsQuery = cpsmdq.cpsmDefinition(type, filter, cicsorq);
        }, map -> Optional.ofNullable((CICSObjectRecordsQueryResult)map.get(type)).map(Stream::of).orElseThrow(() -> new QueryParseException("CPSM definition " + type.getResourceTableName() + " results weren't found")));
    }

    public static <T extends ICPSMManager> QueryUnit<CPSMManagersQuery, Map<ICICSType<? extends ICPSMManager>, CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>> cpsmManager(ICPSMManagerType<T> type, FilterExpression filter) {
        return new QueryUnit<CPSMManagersQuery, Map<ICICSType<? extends ICPSMManager>, CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>>((cicsdq, cicsorq) -> {
            CPSMManagersQuery cPSMManagersQuery = cicsdq.cpsmManager(type, filter, cicsorq);
        }, map -> Optional.ofNullable((CICSObjectRecordsQueryResult)map.get(type)).map(Stream::of).orElseThrow(() -> new QueryParseException("CPSM manager " + type.getResourceTableName() + " results weren't found")));
    }

    public static <T extends ICICSObject> QueryUnit<CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>> groupBy(List<ICICSAttribute<?>> groupBy) {
        return new QueryUnit<CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>, CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>>((cicsorq, end) -> {
            ListIterator i = groupBy.listIterator(groupBy.size());
            while (i.hasPrevious()) {
                Consumer<CICSObjectRecordsQuery> q = end;
                ICICSAttribute att = (ICICSAttribute)i.previous();
                end = x -> {
                    CICSObjectRecordsQuery cICSObjectRecordsQuery = x.groupBy(att, q);
                };
            }
            end.accept(cicsorq);
        }, results -> {
            int i = 0;
            while (i < groupBy.size()) {
                results = results.flatMap(r -> r.getGroups().stream());
                ++i;
            }
            return results;
        });
    }

    public static <T extends ICICSObject> QueryUnit<CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>, Void, List<CICSObjectAggregateRecord>> aggregate(List<ICICSAttribute<?>> attributes) {
        return new QueryUnit<CICSObjectRecordsQuery<T>, Stream<CICSObjectRecordsQueryResult>, Void, List<CICSObjectAggregateRecord>>((cicsorq, v) -> {
            CICSObjectRecordsQuery cICSObjectRecordsQuery = cicsorq.count().aggregateRecord(x -> {
                for (ICICSAttribute attribute : attributes) {
                    try {
                        Class attributeType = attribute.getType();
                        if (attributeType == String.class) {
                            x.stringAttribute(attribute, STRING_AGGREGATION_QUERY);
                            continue;
                        }
                        if (attributeType == Long.class) {
                            x.longAttribute(attribute, LONG_AGGREGATION_QUERY);
                            continue;
                        }
                        if (attributeType == Date.class) {
                            x.dateAttribute(attribute, DATE_AGGREGATION_QUERY);
                            continue;
                        }
                        if (ICICSEnum.class.isAssignableFrom(attributeType)) {
                            x.enumAttribute(attribute, ENUM_AGGREGATION_QUERY);
                            continue;
                        }
                        throw new RuntimeException("Unknown attribute type");
                    }
                    catch (QueryValidationException e) {
                        DEBUG.info("Attribute " + attribute.getPropertyId() + " wasn't supported, skipping", new Object[0]);
                    }
                }
            });
        }, results -> results.map(r -> r.getAggregateRecord()).filter(Optional::isPresent).map(o -> (CICSObjectAggregateRecord)o.get()).collect(Collectors.toList()));
    }

    public static class QueryParseException
    extends RuntimeException {
        public QueryParseException(String message) {
            super(message);
        }
    }

    public static class QueryUnit<ReqA, RespA, ReqB, RespB> {
        private final BiConsumer<ReqA, Consumer<ReqB>> query;
        private final Function<RespA, RespB> parser;

        public QueryUnit(BiConsumer<ReqA, Consumer<ReqB>> query, Function<RespA, RespB> parser) {
            this.query = query;
            this.parser = parser;
        }
    }
}

