/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadRouterType;
import com.ibm.cics.core.model.extra.IWLMRoutersNode;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.adapters.WLMAbstractRuleRelatedAdapter;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.ui.ModelUIPlugin;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.context.WorkloadContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class WLMRoutersAdapter
implements IWLMRoutersNode,
IAdaptable,
IDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(WLMRoutersAdapter.class);
    private IWorkload activeWorkload;

    public WLMRoutersAdapter(IWorkload wlmActiveWorkload) {
        this.activeWorkload = wlmActiveWorkload;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        collector.add(this.getChildren(object), monitor);
    }

    public Long getActiveRoutingRegions() {
        return this.activeWorkload.getActiveRoutingRegions();
    }

    public Object[] getChildren(Object o) {
        DEBUG.enter("getChildren", (Object)this, o);
        WorkloadContext workloadContext = new WorkloadContext((IContext)WLMAbstractRuleRelatedAdapter.getWorkloadBaseContext(this.activeWorkload), this.activeWorkload.getName());
        FilteredContext filteredContext = new FilteredContext((IContext)workloadContext);
        filteredContext.setAttributeValue(WorkloadRouterType.WORKLOAD_OWNER, (Object)this.activeWorkload.getOwningSystemID());
        Object[] workloadRouters = new ICICSObject[]{};
        try {
            workloadRouters = WLMAbstractRuleRelatedAdapter.getWorkloadCPSM(this.activeWorkload).getDefinitions2((ICICSType)WorkloadRouterType.getInstance(), (IContext)filteredContext);
        }
        catch (CICSSystemManagerException e) {
            return this.handleException((Exception)((Object)e));
        }
        DEBUG.exit("getChildren", (Object)workloadRouters);
        return workloadRouters;
    }

    private Object[] handleException(Exception e) {
        if (e.getCause() != null && !(e.getCause() instanceof SystemManagerConnectionException)) {
            DEBUG.event("handleException", (Object)e);
            return new Object[]{new ErrorWrapper(e.getCause())};
        }
        DEBUG.error("getTargetsForScope", (Throwable)e);
        return new Object[0];
    }

    public ICPSM getCPSM() {
        return null;
    }

    public String getLabel(Object o) {
        return Messages.getString("WorkbenchAdapterFactory.routers");
    }

    public Object getParent(Object o) {
        return null;
    }

    public boolean isContainer() {
        return this.activeWorkload.getActiveRoutingRegions() != 0L;
    }

    public Object getAdapter(Class adapterType) {
        Object adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            adapter = new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    return null;
                }
            };
        } else if (adapterType == IWorkbenchAdapter.class) {
            adapter = this;
        }
        return adapter;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return ModelUIPlugin.getTypeImageDescriptor((ICICSType)CICSRegionGroupDefinitionType.getInstance());
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }
}

