/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.breadcrumb;

import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.breadcrumb.CICSplexNode;
import com.ibm.cics.core.ui.breadcrumb.IBreadcrumbNode;
import com.ibm.cics.core.ui.breadcrumb.ManagedRegionNode;
import com.ibm.cics.core.ui.breadcrumb.WorkloadNode;
import com.ibm.cics.model.IActiveWorkloadDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import org.eclipse.swt.graphics.Image;

public class CICSObjectBreadcrumbNodeAdapter
implements IBreadcrumbNode {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICICSObject cicsObject;

    public CICSObjectBreadcrumbNodeAdapter(ICICSObject cicsObject) {
        this.cicsObject = cicsObject;
    }

    @Override
    public Image getImage() {
        return UIPlugin.getTableImage(this.cicsObject.getObjectType().getResourceTableName());
    }

    @Override
    public String getTooltipText() {
        return Messages.getTableDescription(this.cicsObject.getObjectType().getResourceTableName());
    }

    @Override
    public String getText() {
        String nameAttString = this.cicsObject.getObjectType().getNameAttribute();
        Object nameAtt = this.cicsObject.getAttributeValue((IAttribute)this.cicsObject.getObjectType().findAttributeByCicsName(nameAttString));
        if (nameAtt == null) {
            return Messages.getTableDescription(this.cicsObject.getObjectType().getResourceTableName());
        }
        return nameAtt.toString();
    }

    public IBreadcrumbNode getParent() {
        if (this.isWorkloadType(this.cicsObject)) {
            return CICSObjectBreadcrumbNodeAdapter.createWorkloadParent(this.cicsObject);
        }
        if (this.cicsObject instanceof IDefinition) {
            return CICSObjectBreadcrumbNodeAdapter.createCICSDefinitionParent((IDefinition)this.cicsObject);
        }
        if (this.cicsObject instanceof ICICSResource) {
            return CICSObjectBreadcrumbNodeAdapter.createCICSResourceParent((ICICSResource)this.cicsObject);
        }
        return CICSplexNode.createFor(this.cicsObject);
    }

    private boolean isWorkloadType(ICICSObject cicsObject) {
        return cicsObject instanceof IActiveWorkloadDefinition;
    }

    private static IBreadcrumbNode createCICSResourceParent(ICICSResource cicsResource) {
        return new ManagedRegionNode((ICICSObject)cicsResource, cicsResource.getRegionName());
    }

    private static IBreadcrumbNode createWorkloadParent(ICICSObject cicsObject) {
        String workload = Messages.getString("CICSObjectBreadcrumbNodeAdapter_unknown_workload");
        if (cicsObject instanceof IActiveWorkloadDefinition) {
            workload = ((IActiveWorkloadDefinition)cicsObject).getWorkload();
        }
        WorkloadNode node = new WorkloadNode(cicsObject, workload);
        return node;
    }

    private static IBreadcrumbNode createCICSDefinitionParent(IDefinition definition) {
        IPrimaryKey key = (IPrimaryKey)((ICoreObject)definition).getAdapter(IPrimaryKey.class);
        String scope = ContextHelper.findScope((IContext)key);
        if (scope != null) {
            return new ManagedRegionNode((ICICSObject)definition, scope);
        }
        return new CICSplexNode(key.getContext());
    }
}

