/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.model.CICSObjectAggregateRecord;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeAggregation;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.query.AggregateRecordQuery;
import com.ibm.cics.model.query.CICSObjectQuery;
import com.ibm.cics.model.query.CICSObjectQueryResult;
import com.ibm.cics.model.query.CICSObjectRecordsQuery;
import com.ibm.cics.model.query.CICSObjectRecordsQueryResult;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.query.AggregateRecordQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.AggregationMeta;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectQueryImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

class CICSObjectRecordsQueryImpl<Interface extends ICICSObject>
extends Node<CICSObjectRecordsQueryResult>
implements CICSObjectRecordsQuery<Interface> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String FIELD_COUNT = "count";
    private static final String FIELD_RECORDS = "records";
    private static final String FIELD_AGGREGATE_RECORD = "aggregateRecord";
    private static final String FIELD_GROUP_BY = "groupBy";
    private final ICICSType<Interface> type;
    private final Map<ICICSType<?>, AggregationMeta> aggregationMeta;
    private final Collection<ICICSAttribute<?>> mandatoryAttributes;
    private NodeParser<List<CICSObjectQueryResult>> recordsParser;
    private NodeParser<Optional<Map<ICICSAttribute<?>, ? extends ICICSAttributeAggregation>>> aggregateRecordParser;
    private NodeParser<Optional<List<CICSObjectRecordsQueryResult>>> groupsParser;
    private NodeParser<Long> countParser;

    public CICSObjectRecordsQueryImpl(ICICSType<Interface> type, Map<ICICSType<?>, AggregationMeta> aggregationMeta) {
        this(type, Collections.emptyList(), aggregationMeta);
    }

    public CICSObjectRecordsQueryImpl(ICICSType<Interface> type, Collection<ICICSAttribute<?>> mandatoryAttributes, Map<ICICSType<?>, AggregationMeta> aggregationMeta) {
        super(CICSObjectRecordsQueryImpl.getGraphQLTypeName(type));
        this.type = type;
        this.mandatoryAttributes = mandatoryAttributes;
        this.aggregationMeta = aggregationMeta;
    }

    @Override
    public CICSObjectRecordsQueryResult parse(JsonObject o) {
        if (this.aggregateRecordParser != null && this.countParser == null) {
            throw new NodeParseRuntimeException("Must specify count when requesting the aggregate record");
        }
        return new CICSObjectRecordsQueryResultImpl(this.recordsParser == null ? Collections.emptyList() : this.recordsParser.parse(o), this.aggregateRecordParser == null ? Optional.empty() : this.aggregateRecordParser.parse(o).map(attributeAggregations -> {
            CICSObjectAggregateRecord aggregateRecord = new CICSObjectAggregateRecord(this.countParser.parse(o).intValue());
            attributeAggregations.forEach((iCICSAttribute, iCICSAttributeAggregation) -> aggregateRecord.addAttributeAggregation(iCICSAttribute, iCICSAttributeAggregation));
            return aggregateRecord;
        }), this.groupsParser == null ? Collections.emptyList() : this.groupsParser.parse(o).orElse(Collections.emptyList()));
    }

    static String getGraphQLTypeName(ICICSType<?> type) {
        return String.valueOf(type.getResourceTableName()) + "RecordsType";
    }

    public static String getGraphQLFieldName(ICICSType<?> type) {
        return type.getResourceTableName().toLowerCase(Locale.ROOT);
    }

    public CICSObjectRecordsQuery<Interface> fragment(FragmentReference<CICSObjectRecordsQuery<Interface>> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    public CICSObjectRecordsQuery<Interface> count() {
        this.countParser = NodeParser.nonNull(this.longField(FIELD_COUNT));
        return this;
    }

    public CICSObjectRecordsQuery<Interface> records(Consumer<CICSObjectQuery<Interface>> query) {
        this.recordsParser = NodeParser.nonNull(this.arrayFieldNonNullValues(FIELD_RECORDS, new CICSObjectQueryImpl<Interface>(this.type, this.mandatoryAttributes, this.aggregationMeta), query));
        return this;
    }

    public CICSObjectRecordsQuery<Interface> aggregateRecord(Consumer<AggregateRecordQuery> consumer) {
        this.aggregateRecordParser = this.objectField(FIELD_AGGREGATE_RECORD, new AggregateRecordQueryImpl(this.type, this.aggregationMeta.getOrDefault(this.type, AggregationMeta.NULL)), consumer);
        return this;
    }

    public CICSObjectRecordsQuery<Interface> groupBy(ICICSAttribute<?> attribute, Consumer<CICSObjectRecordsQuery<Interface>> consumer) {
        this.groupsParser = this.arrayFieldNonNullValues(FIELD_GROUP_BY, ac -> {
            ArgumentsContext argumentsContext = ac.argString("attribute", attribute.getPropertyId());
        }, new CICSObjectRecordsQueryImpl<Interface>(this.type, this.aggregationMeta), consumer);
        return this;
    }

    private static class CICSObjectRecordsQueryResultImpl
    implements CICSObjectRecordsQueryResult {
        private final List<CICSObjectQueryResult> records;
        private final Optional<CICSObjectAggregateRecord> aggregateRecord;
        private final List<CICSObjectRecordsQueryResult> groups;

        public CICSObjectRecordsQueryResultImpl(List<CICSObjectQueryResult> records, Optional<CICSObjectAggregateRecord> aggregateRecord, List<CICSObjectRecordsQueryResult> groups) {
            this.records = records;
            this.aggregateRecord = aggregateRecord;
            this.groups = groups;
        }

        public List<CICSObjectQueryResult> getRecords() {
            return this.records;
        }

        public Optional<CICSObjectAggregateRecord> getAggregateRecord() {
            return this.aggregateRecord;
        }

        public List<CICSObjectRecordsQueryResult> getGroups() {
            return this.groups;
        }
    }
}

