/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.core.model.AbstractCICSResourceType;
import com.ibm.cics.core.model.AbstractCICSType;
import com.ibm.cics.core.model.AbstractCPSMDefinitionType;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.query.CICSObjectQueryResult;
import com.ibm.cics.model.query.CICSObjectRecordsQueryResult;
import com.ibm.cics.model.query.CICSplexQuery;
import com.ibm.cics.model.query.CICSplexQueryResult;
import com.ibm.cics.model.query.DREPQueryResult;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.model.query.Query;
import com.ibm.cics.model.query.QueryResult;
import com.ibm.cics.model.query.RegionGroupQueryResult;
import com.ibm.cics.model.query.RegionQueryResult;
import com.ibm.cics.model.topology.CPSM;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineBASRepository;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSDefinitionContainer;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSObjectContainer;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSRegion;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSRegionGroup;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSplex;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCPSM;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCPSMDefinitionRepository;
import com.ibm.cics.sm.comm.sm.internal.query.AggregationMeta;
import com.ibm.cics.sm.comm.sm.internal.query.CICSplexQueryImpl;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

class QueryImpl
extends Node<QueryResult>
implements Query {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String GRAPH_QL_TYPE_NAME = "QueryType";
    private static final String FIELD_CICSPLEXES = "cicsplexes";
    private static final String FIELD_CICSPLEX = "cicsplex";
    private final Map<ICICSType<?>, AggregationMeta> aggregationMeta;
    private NodeParser<Optional<CICSplexQueryResult>> cicsplexParser;
    private NodeParser<Optional<List<CICSplexQueryResult>>> cicsplexesParser;

    public QueryImpl(Map<ICICSType<?>, AggregationMeta> aggregationMeta) {
        super(GRAPH_QL_TYPE_NAME);
        this.aggregationMeta = aggregationMeta;
    }

    @Override
    public QueryResult parse(JsonObject o) {
        return new QueryResultImpl(QueryImpl.parseOptionalResult(this.cicsplexParser, o), QueryImpl.parseOptionalList(this.cicsplexesParser, o));
    }

    public Query cicsplex(String name, Consumer<CICSplexQuery> query) {
        this.cicsplexParser = this.objectField(FIELD_CICSPLEX, ac -> {
            ArgumentsContext argumentsContext = ac.argString("name", name);
        }, new CICSplexQueryImpl(this.aggregationMeta), query);
        return this;
    }

    public Query cicsplexes(Consumer<CICSplexQuery> query) {
        this.cicsplexesParser = this.arrayFieldNonNullValues(FIELD_CICSPLEXES, new CICSplexQueryImpl(this.aggregationMeta), query);
        return this;
    }

    public Query fragment(FragmentReference<Query> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    private static class QueryResultImpl
    implements QueryResult {
        private final Optional<CICSplexQueryResult> cicsplexResult;
        private final List<CICSplexQueryResult> cicsplexesResult;

        public QueryResultImpl(Optional<CICSplexQueryResult> cicsplexResult, List<CICSplexQueryResult> cicsplexesResult) {
            this.cicsplexResult = cicsplexResult;
            this.cicsplexesResult = cicsplexesResult;
        }

        public Optional<CICSplexQueryResult> getCICSplexResult() {
            return this.cicsplexResult;
        }

        public List<CICSplexQueryResult> getCICSplexesResult() {
            return this.cicsplexesResult;
        }

        public CPSM asOfflineCPSM() {
            OfflineCPSM cpsm = new OfflineCPSM();
            this.cicsplexResult.ifPresent(cpr -> QueryResultImpl.interpretCICSplexResult(cpsm, cpr));
            this.cicsplexesResult.forEach(cpr -> QueryResultImpl.interpretCICSplexResult(cpsm, cpr));
            return cpsm;
        }

        private static void interpretCICSplexResult(OfflineCPSM cpsm, CICSplexQueryResult result) {
            OfflineCICSplex plex = cpsm.getOrCreateOfflineCICSplex(result.getName());
            result.getRegionResult().ifPresent(region -> QueryResultImpl.interpretRegionResult(plex, region));
            result.getRegionsResult().forEach(region -> QueryResultImpl.interpretRegionResult(plex, region));
            result.getRegionGroupResult().ifPresent(regionGroup -> QueryResultImpl.interpretRegionGroupResult(plex, regionGroup));
            result.getRegionGroupsResult().forEach(regionGroup -> QueryResultImpl.interpretRegionGroupResult(plex, regionGroup));
            result.getDREPResult().ifPresent(drep -> QueryResultImpl.interpretDREPResult(plex, drep));
            QueryResultImpl.interpretCICSResourceResult(plex::getOrCreateOfflineRegion, result.getCICSResources());
        }

        private static void interpretDREPResult(OfflineCICSplex plex, DREPQueryResult result) {
            QueryResultImpl.createObjects(plex.getBASRepository(), result.getCICSDefinitions());
            QueryResultImpl.createObjects(plex.getCPSMDefinitionRepository(), result.getCPSMDefinitions());
        }

        private static void interpretRegionGroupResult(OfflineCICSplex plex, RegionGroupQueryResult result) {
            OfflineCICSRegionGroup group = plex.getOrCreateOfflineRegionGroup(result.getName());
            QueryResultImpl.interpretCICSResourceResult(group::getOrCreateOfflineRegion, result.getCICSResources());
        }

        private static void interpretCICSResourceResult(Function<String, OfflineCICSRegion> containerSupplier, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult> map) {
            map.entrySet().stream().forEach(e -> QueryResultImpl.createObjects(containerSupplier, (ICICSType<? extends ICICSResource>)((ICICSType)e.getKey()), (CICSObjectRecordsQueryResult)e.getValue()));
        }

        private static void createObjects(Function<String, OfflineCICSRegion> containerSupplier, ICICSType<? extends ICICSResource> type, CICSObjectRecordsQueryResult regionResults) {
            regionResults.getRecords().forEach(regionResult -> QueryResultImpl.createCICSResource(containerSupplier, type, regionResult));
        }

        private static <T extends ICICSResource> void createCICSResource(Function<String, OfflineCICSRegion> containerSupplier, ICICSType<T> type, CICSObjectQueryResult result) {
            String regionName = (String)result.getAttributeValues().getAttributeValue((ICICSAttribute)AbstractCICSResourceType.REGION_NAME);
            QueryResultImpl.createObject(containerSupplier.apply(regionName), type, result);
        }

        private static void interpretRegionResult(OfflineCICSplex plex, RegionQueryResult regionResult) {
            OfflineCICSRegion region = plex.getOrCreateOfflineRegion(regionResult.getName());
            QueryResultImpl.createObjects(region, regionResult.getCICSResources());
            OfflineCICSDefinitionContainer csd = region.getCSD();
            regionResult.getCSDResult().ifPresent(csdResult -> QueryResultImpl.createObjects(csd, csdResult.getCICSDefinitions()));
        }

        private static <Interface extends ICICSObject> void createObjects(OfflineCICSObjectContainer<Interface> container, Map<ICICSType<? extends Interface>, CICSObjectRecordsQueryResult> resultsMap) {
            resultsMap.forEach((type, results) -> QueryResultImpl.createObjects(container, type, results));
        }

        private static <Interface extends ICICSObject> void createObjects(OfflineCICSObjectContainer<Interface> container, ICICSType<? extends Interface> type, CICSObjectRecordsQueryResult results) {
            results.getRecords().forEach(qr -> QueryResultImpl.createObject(container, type, qr));
        }

        private static <Interface extends ICICSObject, T extends Interface> void createObject(OfflineCICSObjectContainer<Interface> container, ICICSType<T> type, CICSObjectQueryResult result) {
            OfflineCICSObjectContainer<Interface> newContainer = QueryResultImpl.convertContainer(container, type);
            ICICSObject instance = ((AbstractCICSType)type).createBlind(newContainer, result.getAttributeValues());
            container.add(type, instance);
            result.getFrom().forEach((ref, res) -> QueryResultImpl.createObjects(QueryResultImpl.convertContainer(container, ref.getFromType()), ref.getFromType(), res));
            result.getTo().forEach((ref, res) -> QueryResultImpl.createObject(QueryResultImpl.convertContainer(container, ref.getToType()), ref.getToType(), res));
        }

        static <Interface extends ICICSObject, T extends Interface> OfflineCICSObjectContainer<Interface> convertContainer(OfflineCICSObjectContainer<Interface> container, ICICSType<? extends Interface> cicsType) {
            if (container instanceof OfflineCPSMDefinitionRepository && cicsType instanceof AbstractCICSDefinitionType) {
                return (OfflineCICSObjectContainer)((OfflineCPSMDefinitionRepository)container).getDREP();
            }
            if (container instanceof OfflineCICSDefinitionContainer && cicsType instanceof AbstractCPSMDefinitionType) {
                return (OfflineCICSObjectContainer)((OfflineCICSDefinitionContainer)container).getCPSMDefinitionContainer();
            }
            if (container instanceof OfflineBASRepository && cicsType instanceof AbstractCPSMDefinitionType) {
                return (OfflineCICSObjectContainer)((OfflineBASRepository)container).getCPSMDefinitionContainer();
            }
            return container;
        }
    }
}

