/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.query.CICSObjectRecordsQueryResult;
import com.ibm.cics.model.query.CICSResourcesQuery;
import com.ibm.cics.model.query.CSDQuery;
import com.ibm.cics.model.query.CSDQueryResult;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.model.query.RegionQuery;
import com.ibm.cics.model.query.RegionQueryResult;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.query.AggregationMeta;
import com.ibm.cics.sm.comm.sm.internal.query.CICSResourcesQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CSDQueryImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

class RegionQueryImpl
extends Node<RegionQueryResult>
implements RegionQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String GRAPHQL_TYPE_NAME = "RegionType";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_CSD = "csd";
    private final Map<ICICSType<?>, AggregationMeta> aggregationMeta;
    private NodeParser<String> nameParser;
    private NodeParser<Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult>> cicsResourcesParser;
    private NodeParser<CSDQueryResult> csdResultParser;

    public RegionQueryImpl(Map<ICICSType<?>, AggregationMeta> aggregationMeta) {
        super(GRAPHQL_TYPE_NAME);
        this.aggregationMeta = aggregationMeta;
    }

    public RegionQueryImpl name() {
        this.nameParser = NodeParser.nonNull(this.stringField(FIELD_NAME));
        return this;
    }

    public RegionQuery cicsResources(Consumer<CICSResourcesQuery> query) {
        this.cicsResourcesParser = NodeParser.nonNull(this.objectField("cicsResources", new CICSResourcesQueryImpl(this.aggregationMeta), query));
        return this;
    }

    public RegionQueryImpl csd(Consumer<CSDQuery> query) {
        this.csdResultParser = NodeParser.nonNull(this.objectField(FIELD_CSD, new CSDQueryImpl(this.aggregationMeta), query));
        return this;
    }

    public RegionQuery fragment(FragmentReference<RegionQuery> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    @Override
    public RegionQueryResult parse(JsonObject o) {
        if (this.nameParser == null) {
            throw new NodeParseRuntimeException("Region query node was missing required field 'name'");
        }
        return new RegionQueryResultImpl(this.nameParser.parse(o), RegionQueryImpl.parseMap(this.cicsResourcesParser, o), RegionQueryImpl.parse(this.csdResultParser, o));
    }

    private static class RegionQueryResultImpl
    implements RegionQueryResult {
        private final String name;
        private final Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult> cicsResources;
        private final Optional<CSDQueryResult> csdResult;

        public RegionQueryResultImpl(String name, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult> cicsResources, Optional<CSDQueryResult> csdResult) {
            this.name = name;
            this.cicsResources = Collections.unmodifiableMap(cicsResources);
            this.csdResult = csdResult;
        }

        public String getName() {
            return this.name;
        }

        public Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryResult> getCICSResources() {
            return this.cicsResources;
        }

        public Optional<CSDQueryResult> getCSDResult() {
            return this.csdResult;
        }
    }
}

