/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.query.CICSObjectRecordsQuery;
import com.ibm.cics.model.query.CICSObjectRecordsQueryResult;
import com.ibm.cics.model.query.QueryValidationException;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.query.AggregationMeta;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectRecordsQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.FilterArgumentHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class ResourceQueryNode<T>
extends Node<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final Map<ICICSType<?>, AggregationMeta> aggregationMeta;

    public ResourceQueryNode(String typeId, Map<ICICSType<?>, AggregationMeta> aggregationMeta) {
        super(typeId);
        this.aggregationMeta = aggregationMeta;
    }

    protected <X extends ICICSObject> NodeParser<Optional<CICSObjectRecordsQueryResult>> queryResourcesWithFilter(ICICSType<X> type, FilterExpression filter, Consumer<CICSObjectRecordsQuery<X>> query, List<ICICSAttribute<?>> mandatoryAttributes) {
        if (!this.aggregationMeta.containsKey(type)) {
            throw new QueryValidationException("Unsupported type: " + type.getResourceTableName());
        }
        Consumer<ArgumentsContext> filterArgument = FilterArgumentHelper.toGraphQLArgument(filter);
        HashSet includedAttributes = new HashSet(FilterArgumentHelper.getIncludedAttributes(filter));
        includedAttributes.addAll(mandatoryAttributes);
        return this.objectField(CICSObjectRecordsQueryImpl.getGraphQLFieldName(type), filterArgument, new CICSObjectRecordsQueryImpl<X>(type, includedAttributes, this.aggregationMeta), query);
    }

    protected <X extends ICICSObject> NodeParser<Optional<CICSObjectRecordsQueryResult>> queryResources(ICICSType<X> type, Consumer<CICSObjectRecordsQuery<X>> query, List<ICICSAttribute<?>> mandatoryAttributes) {
        return this.queryResourcesWithFilter(type, FilterExpression.NULL, query, mandatoryAttributes);
    }

    protected <X extends ICICSObject> NodeParser<Optional<CICSObjectRecordsQueryResult>> queryResourcesWithFilter(ICICSType<X> type, FilterExpression filter, Consumer<CICSObjectRecordsQuery<X>> query) {
        return this.queryResourcesWithFilter(type, filter, query, Collections.emptyList());
    }

    protected <X extends ICICSObject> NodeParser<Optional<CICSObjectRecordsQueryResult>> queryResources(ICICSType<X> type, Consumer<CICSObjectRecordsQuery<X>> query) {
        return this.queryResources(type, query, Collections.emptyList());
    }
}

