/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Activator plugin;
    public static final String PLUGIN_ID = "com.ibm.cics.core.comm";
    public static final String TRUSTSTORE_QUALIFIER = "explorer_keystore";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Logger logger = Logger.getLogger(PLUGIN_ID);
        logger.setLevel(Level.FINER);
    }

    public void stop(BundleContext context) throws Exception {
        this.getPluginInstancePreferences().flush();
        super.stop(context);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    private static void logError(Throwable t) {
        Activator.logError(t.getLocalizedMessage(), t);
    }

    private static void logError(String message, Throwable t) {
        Activator.log(4, message, t);
    }

    private static void log(int severity, String message, Throwable t) {
        Status status = new Status(severity, PLUGIN_ID, severity, message, t);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public IEclipsePreferences getPluginInstancePreferences() {
        return InstanceScope.INSTANCE.getNode(this.getBundle().getSymbolicName());
    }

    public IEclipsePreferences getPluginDefaultPreferences() {
        return DefaultScope.INSTANCE.getNode(this.getBundle().getSymbolicName());
    }

    public boolean initialiseTrust() {
        IPath pluginStatePath = this.getStateLocation();
        File pluginStateFile = pluginStatePath.toFile();
        File secureStorageFile = new File(pluginStateFile, "explorer_keystore.jks");
        Boolean storeUpdated = Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.security.initialised", false, null);
        String tsPath = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.trustStore", "", null);
        String ksPath = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.keyStore", "", null);
        if (storeUpdated.booleanValue() && tsPath.equals(secureStorageFile.getAbsolutePath()) && !secureStorageFile.exists() || ksPath.equals(secureStorageFile.getAbsolutePath()) && !secureStorageFile.exists()) {
            storeUpdated = false;
        }
        if (!storeUpdated.booleanValue()) {
            try {
                File file;
                KeyStore ts = KeyStore.getInstance("JKS");
                InputStream stream = Activator.class.getResourceAsStream("/explorer_keystore.jks");
                String java_home = System.getProperty("java.home");
                if (StringUtil.hasContent((String)java_home) && (file = new File(java_home = String.valueOf(java_home) + "/lib/security/cacerts")).exists()) {
                    stream = new FileInputStream(file);
                }
                ts.load(stream, "changeit".toCharArray());
                ts.store(new FileOutputStream(secureStorageFile), "changeit".toCharArray());
            }
            catch (KeyStoreException e) {
                Activator.logError(e);
                this.getPluginInstancePreferences().putBoolean("com.ibm.cics.core.comm.truststore.ignore", true);
            }
            catch (NoSuchAlgorithmException e) {
                Activator.logError(e);
                this.getPluginInstancePreferences().putBoolean("com.ibm.cics.core.comm.truststore.ignore", true);
            }
            catch (CertificateException e) {
                Activator.logError(e);
                this.getPluginInstancePreferences().putBoolean("com.ibm.cics.core.comm.truststore.ignore", true);
            }
            catch (IOException e) {
                Activator.logError(e);
                this.getPluginInstancePreferences().putBoolean("com.ibm.cics.core.comm.truststore.ignore", true);
            }
            this.getPluginInstancePreferences().putBoolean("com.ibm.cics.core.comm.security.initialised", true);
            return true;
        }
        return false;
    }
}

