/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.sm.comm.ApplicationContext;
import com.ibm.cics.sm.comm.Context;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.Debug;
import com.ibm.cics.sm.comm.GroupContext;
import com.ibm.cics.sm.comm.IApplicationContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.INormalizer;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ScopedContext;
import com.ibm.cics.sm.comm.context.ICMASContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SMConnectionRecord {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger = Logger.getLogger("com.ibm.cics.sm.comm");
    private final String resourceType;
    protected IContext context;
    public static final String NORMALIZED_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String FORCE_ATTRIBUTE_UNSUPPORTED = "FORCE_ATTRIBUTE_UNSUPPORTED";
    public static final String DATE_NORMALIZER_KEY = "DATE_NORMALIZER_KEY";
    public static final String STRING_NORMALIZER_KEY = "STRING_NORMALIZER_KEY";
    public static final String LONG_NORMALIZER_KEY = "LONG_NORMALIZER_KEY";
    public static final String ENUM_NORMALIZER_KEY = "ENUM_NORMALIZER_KEY";
    public static final String HEX_NORMALIZER_KEY = "HEX_NORMALIER_KEY";
    public static final String UNSPECIFIED_DATE_STRING = "0000-00-00T00:00:00.000+0000";
    private static final String REGION_NAME = "EYU_CICSNAME";
    private static final String CSDGROUP = "CSDGROUP";

    protected SMConnectionRecord(String resourceType, IContext context) {
        this.resourceType = resourceType;
        this.context = context;
    }

    public IContext getBaseContext() {
        if (IResourceTables.Helper.isCICSDefinition(this.resourceType)) {
            String plex = this.context.getContext();
            String scope = ContextHelper.findScope(this.context);
            String group = null;
            IContext baseContext = scope != null ? new ScopedContext(plex, scope) : new Context(plex);
            String csdGroupString = this.get(CSDGROUP);
            if (!"".equals(csdGroupString)) {
                group = csdGroupString;
            }
            if (group == null) {
                group = ContextHelper.findGroup(this.context);
            }
            if (group != null) {
                baseContext = new GroupContext(baseContext, group);
            }
            return baseContext;
        }
        if (IResourceTables.Helper.isCICSResource(this.resourceType)) {
            IScopedContext baseContext = new ScopedContext(this.context.getContext(), this.get(REGION_NAME));
            IApplicationContext applicationContext = ContextHelper.getContextFrom(this.context, IApplicationContext.class);
            if (applicationContext != null) {
                baseContext = new ApplicationContext(baseContext, applicationContext.getPlatformName(), applicationContext.getApplicationName(), applicationContext.getApplicationMajorVersion(), applicationContext.getApplicationMinorVersion(), applicationContext.getApplicationMicroVersion());
            }
            return baseContext;
        }
        if (IResourceTables.Helper.isCPSMManager(this.resourceType)) {
            if (IResourceTables.Helper.requiresCMASContext(this.resourceType)) {
                return new ICMASContext(){

                    @Override
                    public String getContext() {
                        return SMConnectionRecord.this.context.getContext();
                    }
                };
            }
            return new Context(this.context.getContext());
        }
        if (IResourceTables.Helper.isCPSMDefinition(this.resourceType)) {
            return new Context(this.context.getContext());
        }
        if (IResourceTables.Helper.isCSDDefinition(this.resourceType)) {
            String plex = this.context.getContext();
            String scope = ContextHelper.findScope(this.context);
            return new ScopedContext(plex, scope);
        }
        return this.context;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public abstract Map<String, INormalizer> getNormalizers();

    public abstract String get(String var1);

    public abstract String toExternalForm();

    public Iterator iterator() {
        return Collections.EMPTY_SET.iterator();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.toExternalForm() + "]";
    }

    public String getKeyValue() throws ConnectionException {
        return this.get(this.getKeyFieldName());
    }

    protected String getKeyFieldName() {
        if ("CICSRGN".equals(this.getResourceType())) {
            return REGION_NAME;
        }
        return "NAME";
    }

    public static class GenericDateNormalizer
    implements INormalizer {
        private final String denormalizedDateFormatString;

        public GenericDateNormalizer(String denormalizedDateFormatString) {
            this.denormalizedDateFormatString = denormalizedDateFormatString;
        }

        @Override
        public String normalize(String denormalizedValue) {
            if (denormalizedValue == null) {
                if (Debug.DEBUG_RECORD) {
                    logger.logp(Level.FINER, this.getClass().getName(), "normalize", "No date normalization was performed on null input");
                }
                return denormalizedValue;
            }
            Date date = null;
            try {
                SimpleDateFormat myDateFormat = new SimpleDateFormat(this.denormalizedDateFormatString);
                date = myDateFormat.parse(denormalizedValue);
            }
            catch (ParseException ex) {
                if (Debug.DEBUG_RECORD) {
                    logger.logp(Level.FINER, this.getClass().getName(), "normalize", "No date normalization was performed on input string '" + denormalizedValue + "' by pattern '" + this.denormalizedDateFormatString + "'", ex);
                }
                return denormalizedValue;
            }
            SimpleDateFormat normalizedDateFormat = new SimpleDateFormat(SMConnectionRecord.NORMALIZED_DATE_FORMAT_STRING.substring(0, 25));
            String normalizedValue = normalizedDateFormat.format(date);
            return normalizedValue;
        }

        @Override
        public String denormalize(String normalizedValue) {
            if (normalizedValue == null) {
                logger.logp(Level.WARNING, this.getClass().getName(), "denormalize", "Can't perform normalization on null input");
                return normalizedValue;
            }
            Date date = null;
            try {
                SimpleDateFormat normalizedDateFormat = new SimpleDateFormat(SMConnectionRecord.NORMALIZED_DATE_FORMAT_STRING);
                date = normalizedDateFormat.parse(normalizedValue);
            }
            catch (ParseException ex) {
                if (Debug.DEBUG_RECORD) {
                    logger.logp(Level.FINER, this.getClass().getName(), "denormalise", "No date denormalization was performed on input string '" + normalizedValue + "' by pattern '" + SMConnectionRecord.NORMALIZED_DATE_FORMAT_STRING + "'", ex);
                }
                return normalizedValue;
            }
            SimpleDateFormat myDateFormat = new SimpleDateFormat(this.denormalizedDateFormatString);
            String myValue = myDateFormat.format(date);
            return myValue;
        }
    }
}

