/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.eclipse.common.ops.ExecutionFailedException;
import com.ibm.cics.eclipse.common.ops.IOperationExecutionDelegate;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GetExecutionDelegate
implements IOperationExecutionDelegate<IPrimaryKey> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICICSType<?> cicsType;
    private final ICPSM cpsm;
    private ICICSObject cicsObject;
    private final boolean errorOnMissing;

    public GetExecutionDelegate(ICICSType<?> cicsType, ICPSM cpsm, boolean errorOnMissing) {
        this.cicsType = cicsType;
        this.cpsm = cpsm;
        this.errorOnMissing = errorOnMissing;
    }

    public GetExecutionDelegate(ICICSType<?> cicsType, ICPSM cpsm) {
        this(cicsType, cpsm, true);
    }

    public void execute(IPrimaryKey target) throws ExecutionFailedException {
        try {
            ICICSObject cObject = this.cpsm.get2(this.cicsType, target);
            if (cObject == null && this.errorOnMissing) {
                throw new ExecutionFailedException((IStatus)new Status(2, "com.ibm.cics.core.ui", GetExecutionDelegate.getMissingMessage(this.cicsType, target)));
            }
            this.cicsObject = cObject;
        }
        catch (CICSSystemManagerException ex) {
            IStatus status = ExceptionMessageHelper.getStatus((CICSActionException)ex, this.cicsType, 2);
            throw new ExecutionFailedException(status);
        }
    }

    public static String getMissingMessage(ICICSType<?> cicsType, IPrimaryKey target) {
        String typeDescription = Messages.getTableDescription(cicsType);
        String targetDescripton = GetExecutionDelegate.getTargetName(cicsType, target);
        return com.ibm.cics.core.ui.actions.Messages.getString("GetExecutionDelegate.missingResource", typeDescription, targetDescripton);
    }

    private static String getTargetName(ICICSType<?> cicsType, IPrimaryKey target) {
        String attributeValue = target.getAttributeValue(cicsType.getNameAttribute());
        if (attributeValue != null) {
            return attributeValue;
        }
        return "";
    }

    public ICICSObject getCICSObject() {
        return this.cicsObject;
    }

    public String getOperationDescription(IPrimaryKey target) {
        String location = ExceptionMessageHelper.getContextOrScopeNameFor((IContext)target);
        String name = GetExecutionDelegate.getTargetName(this.cicsType, target);
        String typeName = Messages.getTableDescription(this.cicsType.getResourceTableName());
        return com.ibm.cics.core.ui.actions.Messages.getString("operation.get.description", typeName, name, location);
    }

    public String getOperationName() {
        return com.ibm.cics.core.ui.actions.Messages.getString("GetExecutionDelegate.get");
    }

    public int getID() {
        return 607;
    }
}

