/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.sm.comm.AbstractFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FilteredContext
extends AbstractFilteredContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Map<String, String> filterCriteria = new HashMap<String, String>();

    public FilteredContext(IContext context) {
        super(context);
    }

    public FilteredContext(IContext context, AttributeValue<?> ... attributeValues) {
        super(context);
        AttributeValue<?>[] attributeValueArray = attributeValues;
        int n = attributeValues.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeValue<?> attributeValue = attributeValueArray[n2];
            this.setAttributeValue(attributeValue);
            ++n2;
        }
    }

    private <T> void setAttributeValue(AttributeValue<T> attributeValue) {
        this.setAttributeValue(attributeValue.getAttribute(), attributeValue.getValue());
    }

    public <T> void setAttributeValue(ICICSAttribute<? super T> attribute, T value) {
        String externalValue = attribute.internalToExternal(value);
        this.filterCriteria.put(attribute.getCicsName(), externalValue);
    }

    public Set<String> getAttributeNames() {
        return this.filterCriteria.keySet();
    }

    public String getAttributeValue(String attributeName) {
        return this.filterCriteria.get(attributeName);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " Criteria: " + this.filterCriteria.toString();
    }
}

