/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.ApplicationDefinitionReference;
import com.ibm.cics.core.model.ApplicationDefinitionType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CPSMDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IPlatformDefinitionReference;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class ApplicationDefinition
extends CPSMDefinition
implements IApplicationDefinition {
    private IApplicationDefinition.ChangeAgentValue _changeagent;
    private String _name;
    private String _description;
    private String _platdef;
    private String _appldir;
    private Long _majorversion;
    private Long _minorversion;
    private Long _microversion;
    private String _binddir;

    public ApplicationDefinition(ICPSMDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._changeagent = (IApplicationDefinition.ChangeAgentValue)avm.getAttributeValue(ApplicationDefinitionType.CHANGE_AGENT, true);
        this._name = (String)avm.getAttributeValue(ApplicationDefinitionType.NAME);
        this._description = (String)avm.getAttributeValue(ApplicationDefinitionType.DESCRIPTION, true);
        this._platdef = (String)avm.getAttributeValue(ApplicationDefinitionType.PLATFORM_DEFINITION);
        this._appldir = (String)avm.getAttributeValue(ApplicationDefinitionType.APPLICATION_DIRECTORY, true);
        this._majorversion = (Long)avm.getAttributeValue(ApplicationDefinitionType.MAJOR_VERSION);
        this._minorversion = (Long)avm.getAttributeValue(ApplicationDefinitionType.MINOR_VERSION);
        this._microversion = (Long)avm.getAttributeValue(ApplicationDefinitionType.MICRO_VERSION);
        this._binddir = (String)avm.getAttributeValue(ApplicationDefinitionType.BINDING_DIRECTORY, true);
    }

    public ApplicationDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("CHANGEAGENT");
        this._changeagent = (IApplicationDefinition.ChangeAgentValue)((CICSAttribute)ApplicationDefinitionType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)ApplicationDefinitionType.NAME).get(stringValue, normalizers);
        stringValue = record.get("DESCRIPTION");
        this._description = (String)((CICSAttribute)ApplicationDefinitionType.DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get("PLATDEF");
        this._platdef = (String)((CICSAttribute)ApplicationDefinitionType.PLATFORM_DEFINITION).get(stringValue, normalizers);
        stringValue = record.get("APPLDIR");
        this._appldir = (String)((CICSAttribute)ApplicationDefinitionType.APPLICATION_DIRECTORY).get(stringValue, normalizers);
        stringValue = record.get("MAJORVERSION");
        this._majorversion = (Long)((CICSAttribute)ApplicationDefinitionType.MAJOR_VERSION).get(stringValue, normalizers);
        stringValue = record.get("MINORVERSION");
        this._minorversion = (Long)((CICSAttribute)ApplicationDefinitionType.MINOR_VERSION).get(stringValue, normalizers);
        stringValue = record.get("MICROVERSION");
        this._microversion = (Long)((CICSAttribute)ApplicationDefinitionType.MICRO_VERSION).get(stringValue, normalizers);
        stringValue = record.get("BINDDIR");
        this._binddir = (String)((CICSAttribute)ApplicationDefinitionType.BINDING_DIRECTORY).get(stringValue, normalizers);
    }

    public IApplicationDefinition.ChangeAgentValue getChangeAgent() {
        return this._changeagent;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public String getPlatformDefinition() {
        return this._platdef;
    }

    public String getApplicationDirectory() {
        return this._appldir;
    }

    public Long getMajorVersion() {
        return this._majorversion;
    }

    public Long getMinorVersion() {
        return this._minorversion;
    }

    public Long getMicroVersion() {
        return this._microversion;
    }

    public String getBindingDirectory() {
        return this._binddir;
    }

    public ApplicationDefinitionType getObjectType() {
        return ApplicationDefinitionType.getInstance();
    }

    @Override
    public ApplicationDefinitionReference getCICSObjectReference() {
        return new ApplicationDefinitionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ApplicationDefinitionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == ApplicationDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ApplicationDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == ApplicationDefinitionType.PLATFORM_DEFINITION) {
            return (V)this.getPlatformDefinition();
        }
        if (attribute == ApplicationDefinitionType.APPLICATION_DIRECTORY) {
            return (V)this.getApplicationDirectory();
        }
        if (attribute == ApplicationDefinitionType.MAJOR_VERSION) {
            return (V)this.getMajorVersion();
        }
        if (attribute == ApplicationDefinitionType.MINOR_VERSION) {
            return (V)this.getMinorVersion();
        }
        if (attribute == ApplicationDefinitionType.MICRO_VERSION) {
            return (V)this.getMicroVersion();
        }
        if (attribute == ApplicationDefinitionType.BINDING_DIRECTORY) {
            return (V)this.getBindingDirectory();
        }
        return super.getAttributeValue(attribute);
    }

    public IPlatformDefinitionReference getPlatformDefinitionReference() {
        return (IPlatformDefinitionReference)ApplicationDefinitionType.PLATFORM_DEFINITION_REFERENCE.getTo((ICICSObject)this);
    }
}

