/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DB2TransactionDefinitionReference;
import com.ibm.cics.core.model.DB2TransactionDefinitionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.IDB2TransactionDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableDB2TransactionDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableDB2TransactionDefinition
extends MutableCICSDefinition
implements IMutableDB2TransactionDefinition {
    private IDB2TransactionDefinition delegate;
    private MutableSMRecord record;

    public MutableDB2TransactionDefinition(ICPSM cpsm, IContext context, IDB2TransactionDefinition cicsObject) {
        super(cpsm, context, (ICICSDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("DB2TDEF");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public IDB2TransactionDefinition.ChangeAgentValue getChangeAgent() {
        String result = this.record.get("CHANGEAGENT");
        if (result == null) {
            return this.delegate.getChangeAgent();
        }
        return (IDB2TransactionDefinition.ChangeAgentValue)((CICSAttribute)DB2TransactionDefinitionType.CHANGE_AGENT).get(result, this.record.getNormalizers());
    }

    public String getDB2Entry() {
        String result = this.record.get("ENTRY");
        if (result == null) {
            return this.delegate.getDB2Entry();
        }
        return (String)((CICSAttribute)DB2TransactionDefinitionType.DB2_ENTRY).get(result, this.record.getNormalizers());
    }

    public String getTransaction() {
        String result = this.record.get("TRANSID");
        if (result == null) {
            return this.delegate.getTransaction();
        }
        return (String)((CICSAttribute)DB2TransactionDefinitionType.TRANSACTION).get(result, this.record.getNormalizers());
    }

    public String getUserdata1() {
        String result = this.record.get("USERDATA1");
        if (result == null) {
            return this.delegate.getUserdata1();
        }
        return (String)((CICSAttribute)DB2TransactionDefinitionType.USERDATA_1).get(result, this.record.getNormalizers());
    }

    public String getUserdata2() {
        String result = this.record.get("USERDATA2");
        if (result == null) {
            return this.delegate.getUserdata2();
        }
        return (String)((CICSAttribute)DB2TransactionDefinitionType.USERDATA_2).get(result, this.record.getNormalizers());
    }

    public String getUserdata3() {
        String result = this.record.get("USERDATA3");
        if (result == null) {
            return this.delegate.getUserdata3();
        }
        return (String)((CICSAttribute)DB2TransactionDefinitionType.USERDATA_3).get(result, this.record.getNormalizers());
    }

    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)DB2TransactionDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public void setChangeAgent(IDB2TransactionDefinition.ChangeAgentValue _changeAgent) {
        if (_changeAgent.equals((Object)this.delegate.getChangeAgent())) {
            this.record.set("CHANGEAGENT", null);
        } else {
            DB2TransactionDefinitionType.CHANGE_AGENT.validate((Object)_changeAgent);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.CHANGE_AGENT).set(_changeAgent, this.record.getNormalizers());
            this.record.set("CHANGEAGENT", connectionSpecificExternalValue);
        }
    }

    public void setDB2Entry(String _DB2Entry) {
        if (_DB2Entry.equals(this.delegate.getDB2Entry())) {
            this.record.set("ENTRY", null);
        } else {
            DB2TransactionDefinitionType.DB2_ENTRY.validate((Object)_DB2Entry);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.DB2_ENTRY).set(_DB2Entry, this.record.getNormalizers());
            this.record.set("ENTRY", connectionSpecificExternalValue);
        }
    }

    public void setTransaction(String _transaction) {
        if (_transaction.equals(this.delegate.getTransaction())) {
            this.record.set("TRANSID", null);
        } else {
            DB2TransactionDefinitionType.TRANSACTION.validate((Object)_transaction);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.TRANSACTION).set(_transaction, this.record.getNormalizers());
            this.record.set("TRANSID", connectionSpecificExternalValue);
        }
    }

    public void setUserdata1(String _userdata1) {
        if (_userdata1.equals(this.delegate.getUserdata1())) {
            this.record.set("USERDATA1", null);
        } else {
            DB2TransactionDefinitionType.USERDATA_1.validate((Object)_userdata1);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.USERDATA_1).set(_userdata1, this.record.getNormalizers());
            this.record.set("USERDATA1", connectionSpecificExternalValue);
        }
    }

    public void setUserdata2(String _userdata2) {
        if (_userdata2.equals(this.delegate.getUserdata2())) {
            this.record.set("USERDATA2", null);
        } else {
            DB2TransactionDefinitionType.USERDATA_2.validate((Object)_userdata2);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.USERDATA_2).set(_userdata2, this.record.getNormalizers());
            this.record.set("USERDATA2", connectionSpecificExternalValue);
        }
    }

    public void setUserdata3(String _userdata3) {
        if (_userdata3.equals(this.delegate.getUserdata3())) {
            this.record.set("USERDATA3", null);
        } else {
            DB2TransactionDefinitionType.USERDATA_3.validate((Object)_userdata3);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.USERDATA_3).set(_userdata3, this.record.getNormalizers());
            this.record.set("USERDATA3", connectionSpecificExternalValue);
        }
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESCRIPTION", null);
        } else {
            DB2TransactionDefinitionType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESCRIPTION", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == DB2TransactionDefinitionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == DB2TransactionDefinitionType.DB2_ENTRY) {
            return (V)this.getDB2Entry();
        }
        if (attribute == DB2TransactionDefinitionType.TRANSACTION) {
            return (V)this.getTransaction();
        }
        if (attribute == DB2TransactionDefinitionType.USERDATA_1) {
            return (V)this.getUserdata1();
        }
        if (attribute == DB2TransactionDefinitionType.USERDATA_2) {
            return (V)this.getUserdata2();
        }
        if (attribute == DB2TransactionDefinitionType.USERDATA_3) {
            return (V)this.getUserdata3();
        }
        return super.getAttributeValue(attribute);
    }

    public DB2TransactionDefinitionType getObjectType() {
        return DB2TransactionDefinitionType.getInstance();
    }

    @Override
    public DB2TransactionDefinitionReference getCICSObjectReference() {
        return new DB2TransactionDefinitionReference(this.getCICSContainer(), this.getName(), this.getVersion(), this.getCSDGroup());
    }
}

