/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.common.util.StaleableEventListener;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.CredentialsManagerListener;
import com.ibm.cics.core.connections.IConnectionCredentialsManager;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.BiDiMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConnectionCredentialsManager
implements IConnectionCredentialsManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CREDENTIALS_ID = "credentialsId";
    private static final String CONNECTION_ID = "connectionId";
    private static final String MAPPING = "mapping";
    private static final String CREDENTIAL_MAPPINGS = "credentialMappings";
    private static final Debug debug = new Debug(ConnectionCredentialsManager.class);
    private static final XPathExpression mappingsExpression;
    private IPath location;
    private BiDiMap<String, String> associations = new BiDiMap();
    private ICredentialsManager credentialsManager;
    private boolean loading = true;
    private EventManager<ConnectionCredentialsManagerEvent> eventManager = new EventManager();

    static {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            mappingsExpression = xPath.compile("/credentialMappings/mapping");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionCredentialsManager(ICredentialsManager credentialsManager) {
        debug.enter("ConnectionCredentialsManager");
        this.credentialsManager = credentialsManager;
        credentialsManager.addCredentialsManagerListener(new CredentialsManagerListener(){

            public void event(CredentialsManagerListener.CredentialsManagerEvent event) {
                if (event instanceof CredentialsManagerListener.CredentialModifiedEvent) {
                    String credentialsId = ((CredentialsManagerListener.CredentialModifiedEvent)event).getExisting().getID();
                    ConnectionCredentialsManager.this.credentialModified(credentialsId);
                } else if (event instanceof CredentialsManagerListener.CredentialRemovedEvent) {
                    String credentialsId = ((CredentialsManagerListener.CredentialRemovedEvent)event).getRemoved().getID();
                    ConnectionCredentialsManager.this.credentialRemoved(credentialsId);
                }
            }
        });
        try {
            Path pluginMetadataPath = new Path(Platform.getInstanceLocation().getDataArea("com.ibm.cics.core.connections").getFile());
            this.location = pluginMetadataPath.append("/credentialMappings.xml");
        }
        catch (IOException e) {
            debug.error("ConnectionCredentialsManager", "loading connection credential mappings failed", (Throwable)e);
            this.location = new Path(Platform.getInstanceLocation().getURL().getFile());
        }
        try {
            this.load();
        }
        catch (IOException ex) {
            debug.error("<init>", "loading connection credential mappings failed", (Throwable)ex);
        }
        this.loading = false;
        debug.exit("ConnectionCredentialsManager", (Object)this.location);
    }

    private void credentialModified(String credentialsId) {
        Set<String> affectedConnections = this.associations.getValuesMap().get(credentialsId);
        if (affectedConnections != null) {
            affectedConnections = new HashSet<String>(affectedConnections);
            for (String connectionId : affectedConnections) {
                this.associate(connectionId, credentialsId);
            }
        }
    }

    private void credentialRemoved(String credentialsId) {
        Set<String> affectedConnections = this.associations.getValuesMap().get(credentialsId);
        if (affectedConnections != null) {
            affectedConnections = new HashSet<String>(affectedConnections);
            for (String connectionId : affectedConnections) {
                this.associate(connectionId, null);
            }
        }
    }

    public void addListener(ConnectionCredentialsManagerListener listener) {
        this.eventManager.addListener((IStaleableEventListener)listener);
    }

    @Override
    public void associate(String connectionId, String credentialsId) {
        CredentialsConfiguration credentials = this.credentialsManager.findCredentialsConfigurationByID(credentialsId);
        if (credentials != null) {
            String oldId = this.associations.getKeysMap().put(connectionId, credentialsId);
            this.eventManager.notifyListeners((Object)new ConnectionCredentialsChangedEvent(connectionId, credentials));
        } else {
            String oldId = this.associations.getKeysMap().remove(connectionId);
            if (oldId != null) {
                this.eventManager.notifyListeners((Object)new ConnectionCredentialsChangedEvent(connectionId, null));
            }
        }
        if (!this.loading) {
            try {
                this.save();
            }
            catch (IOException ex) {
                debug.error("associate", "saving connection credentials mapping failed", (Throwable)ex);
            }
        }
    }

    public CredentialsConfiguration getCredentials(String connectionId) {
        String credentialsId = this.associations.getKeysMap().get(connectionId);
        if (credentialsId != null) {
            CredentialsConfiguration credentials = this.credentialsManager.findCredentialsConfigurationByID(credentialsId);
            if (credentials != null) {
                return credentials;
            }
            debug.warning("getCredentials", (Object)("connectionId=" + connectionId), (Object)("Couldn't find credentials: " + credentialsId + ", so removing the binding"));
            this.associate(connectionId, null);
            return null;
        }
        return null;
    }

    private void save() throws IOException {
        if (this.location.toFile().exists() && !this.location.toFile().delete()) {
            throw new IOException("couldn't delete existing file: " + this.location);
        }
        File parentFile = this.location.toFile().getParentFile();
        if (parentFile == null) {
            throw new IOException("Couldn't determine parent for location: " + this.location);
        }
        parentFile.mkdirs();
        try (OutputStream os = null;){
            try {
                os = new FileOutputStream(new File(this.location.toOSString()));
                os = new BufferedOutputStream(os);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element connectionsElement = document.createElement(CREDENTIAL_MAPPINGS);
                document.appendChild(connectionsElement);
                for (Map.Entry<String, String> association : this.associations.getKeysMap().entrySet()) {
                    if (association.getKey() == null || association.getValue() == null) continue;
                    Element typeElement = document.createElement(MAPPING);
                    connectionsElement.appendChild(typeElement);
                    typeElement.setAttribute(CONNECTION_ID, association.getKey());
                    typeElement.setAttribute(CREDENTIALS_ID, association.getValue());
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.setOutputProperty("indent", "yes");
                StreamResult result = new StreamResult(os);
                transformer.transform(new DOMSource(document), result);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
            catch (TransformerException e) {
                throw new IOException(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void load() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ICredentialsManager getCredentialsManager() {
        return this.credentialsManager;
    }

    public static class ConnectionCredentialsChangedEvent
    extends ConnectionCredentialsManagerEvent {
        private String connectionId;
        private CredentialsConfiguration credentials;

        public ConnectionCredentialsChangedEvent(String connectionId, CredentialsConfiguration credentials) {
            this.connectionId = connectionId;
            this.credentials = credentials;
        }

        public String getConnectionId() {
            return this.connectionId;
        }

        public CredentialsConfiguration getCredentials() {
            return this.credentials;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.credentials == null ? 0 : this.credentials.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionCredentialsChangedEvent other = (ConnectionCredentialsChangedEvent)obj;
            if (this.connectionId == null ? other.connectionId != null : !this.connectionId.equals(other.connectionId)) {
                return false;
            }
            return !(this.credentials == null ? other.credentials != null : !this.credentials.equals((Object)other.credentials));
        }

        public String toString() {
            return "ConnectionCredentialsChangedEvent [connectionId=" + this.connectionId + ", credentials=" + this.credentials + "]";
        }
    }

    public static abstract class ConnectionCredentialsManagerEvent {
    }

    public static abstract class ConnectionCredentialsManagerListener
    extends StaleableEventListener<ConnectionCredentialsManagerEvent> {
    }
}

