/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.builders;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DefinitionBuilder;
import com.ibm.cics.core.model.PlatformDefinitionType;
import com.ibm.cics.core.model.builders.BuilderHelper;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.IPlatformDefinition;
import com.ibm.cics.model.IPlatformDefinitionReference;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutablePlatformDefinition;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class PlatformDefinitionBuilder
extends DefinitionBuilder
implements IMutablePlatformDefinition {
    private MutableSMRecord record = new MutableSMRecord("PLATDEF");

    public PlatformDefinitionBuilder(String _name, String _platformDirectory, String _description) {
        this.setName(_name);
        this.setPlatformDirectory(_platformDirectory);
        this.setDescription(_description);
    }

    public PlatformDefinitionBuilder(String _name, String _platformDirectory, String _description, IPlatformDefinition anotherDef) throws Exception {
        this(_name, _platformDirectory, _description);
        BuilderHelper.copyAttributes((IDefinition)anotherDef, this);
    }

    public ICPSMDefinitionContainer getCICSContainer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SMConnectionRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getRecord() + "]";
    }

    public void setChangeAgent(IPlatformDefinition.ChangeAgentValue _changeAgent) {
        String connectionSpecificExternalValue = null;
        if (_changeAgent != null && _changeAgent != PlatformDefinitionType.CHANGE_AGENT.getUnsupportedValue()) {
            PlatformDefinitionType.CHANGE_AGENT.validate((Object)_changeAgent);
            connectionSpecificExternalValue = ((CICSAttribute)PlatformDefinitionType.CHANGE_AGENT).set(_changeAgent, this.record.getNormalizers());
        }
        this.record.set("CHANGEAGENT", connectionSpecificExternalValue);
    }

    public void setName(String _name) {
        String connectionSpecificExternalValue = null;
        if (_name != null && _name != PlatformDefinitionType.NAME.getUnsupportedValue()) {
            PlatformDefinitionType.NAME.validate((Object)_name);
            connectionSpecificExternalValue = ((CICSAttribute)PlatformDefinitionType.NAME).set(_name, this.record.getNormalizers());
        }
        this.record.set("NAME", connectionSpecificExternalValue);
    }

    public void setDescription(String _description) {
        String connectionSpecificExternalValue = null;
        if (_description != null && _description != PlatformDefinitionType.DESCRIPTION.getUnsupportedValue()) {
            PlatformDefinitionType.DESCRIPTION.validate((Object)_description);
            connectionSpecificExternalValue = ((CICSAttribute)PlatformDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
        }
        this.record.set("DESCRIPTION", connectionSpecificExternalValue);
    }

    public void setPlatformDirectory(String _platformDirectory) {
        String connectionSpecificExternalValue = null;
        if (_platformDirectory != null && _platformDirectory != PlatformDefinitionType.PLATFORM_DIRECTORY.getUnsupportedValue()) {
            PlatformDefinitionType.PLATFORM_DIRECTORY.validate((Object)_platformDirectory);
            connectionSpecificExternalValue = ((CICSAttribute)PlatformDefinitionType.PLATFORM_DIRECTORY).set(_platformDirectory, this.record.getNormalizers());
        }
        this.record.set("PLATDIR", connectionSpecificExternalValue);
    }

    public IPlatformDefinition.ChangeAgentValue getChangeAgent() {
        String result = this.record.get("CHANGEAGENT");
        return result == null ? null : (IPlatformDefinition.ChangeAgentValue)((CICSAttribute)PlatformDefinitionType.CHANGE_AGENT).get(result, this.record.getNormalizers());
    }

    @Override
    public String getName() {
        String result = this.record.get("NAME");
        return result == null ? null : (String)((CICSAttribute)PlatformDefinitionType.NAME).get(result, this.record.getNormalizers());
    }

    @Override
    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        return result == null ? null : (String)((CICSAttribute)PlatformDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public String getPlatformDirectory() {
        String result = this.record.get("PLATDIR");
        return result == null ? null : (String)((CICSAttribute)PlatformDefinitionType.PLATFORM_DIRECTORY).get(result, this.record.getNormalizers());
    }

    @Override
    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == PlatformDefinitionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == PlatformDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == PlatformDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == PlatformDefinitionType.PLATFORM_DIRECTORY) {
            return (V)this.getPlatformDirectory();
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + PlatformDefinitionType.getInstance());
    }

    @Override
    public <V> void setAttributeValue(IAttribute<V> attribute, V value) {
        if (attribute == PlatformDefinitionType.CHANGE_AGENT) {
            this.setChangeAgent((IPlatformDefinition.ChangeAgentValue)PlatformDefinitionType.CHANGE_AGENT.getType().cast(value));
        } else if (attribute == PlatformDefinitionType.NAME) {
            this.setName((String)PlatformDefinitionType.NAME.getType().cast(value));
        } else if (attribute == PlatformDefinitionType.DESCRIPTION) {
            this.setDescription((String)PlatformDefinitionType.DESCRIPTION.getType().cast(value));
        } else if (attribute == PlatformDefinitionType.PLATFORM_DIRECTORY) {
            this.setPlatformDirectory((String)PlatformDefinitionType.PLATFORM_DIRECTORY.getType().cast(value));
        } else {
            throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not settable for type " + PlatformDefinitionType.getInstance());
        }
    }

    public PlatformDefinitionType getObjectType() {
        return PlatformDefinitionType.getInstance();
    }

    public IPlatformDefinitionReference getCICSObjectReference() {
        return null;
    }

    public ICICSObjectSet<IApplicationDefinition> getApplicationDefinitions() {
        throw new UnsupportedOperationException();
    }
}

