/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSTypesRegistry;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.sm.internal.query.AggregationMeta;
import com.ibm.cics.sm.comm.sm.internal.query.LongAggregationQueryImpl;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CICSIntrospectionQueryParser {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(CICSIntrospectionQueryParser.class);
    private static final String SUFFIX = "AggregateRecordType";

    public static Map<ICICSType<?>, AggregationMeta> parseIntrospectionResult(JsonElement json) {
        debug.enter("parseIntrospectionQuery", (Object)json);
        Map<Object, Object> aggregationMeta = new HashMap();
        JsonArray typesArr = null;
        try {
            typesArr = json.getAsJsonObject().get("data").getAsJsonObject().get("__schema").getAsJsonObject().get("types").getAsJsonArray();
            aggregationMeta = StreamSupport.stream(typesArr.spliterator(), false).map(JsonElement::getAsJsonObject).filter(e -> e.get("name").getAsString().endsWith(SUFFIX)).map(typeElement -> CICSIntrospectionQueryParser.parseType((JsonElement)typeElement)).filter(tEO -> tEO.isPresent()).map(tEO -> (AbstractMap.SimpleEntry)tEO.get()).collect(Collectors.toMap(tE -> (ICICSType)tE.getKey(), tE -> (AggregationMeta)tE.getValue()));
            debug.exit("parseIntrospectionQuery", aggregationMeta);
            return Collections.unmodifiableMap(aggregationMeta);
        }
        catch (JsonSyntaxException | IllegalStateException e2) {
            return Collections.emptyMap();
        }
    }

    private static Optional<AbstractMap.SimpleEntry<ICICSType<?>, AggregationMeta>> parseType(JsonElement typeElement) {
        JsonObject typeObject = typeElement.getAsJsonObject();
        String name = typeObject.get("name").getAsString();
        String resourceTableName = name.substring(0, name.length() - SUFFIX.length());
        ICICSType type = CICSTypesRegistry.findForResourceTableName((String)resourceTableName);
        if (type == null) {
            return Optional.empty();
        }
        JsonElement fieldsElem = typeObject.get("fields");
        final HashSet<ICICSAttribute> fieldSet = new HashSet<ICICSAttribute>();
        final HashSet<ICICSAttribute> unsupportedMeta = new HashSet<ICICSAttribute>();
        if (fieldsElem != null && !fieldsElem.isJsonNull()) {
            JsonArray fieldsArr = fieldsElem.getAsJsonArray();
            for (JsonElement attributeElement : fieldsArr) {
                ICICSAttribute longAttribute;
                Optional<Map.Entry<String, Long>> metaValue;
                JsonElement typeNameE;
                JsonElement nameElement;
                JsonObject jsonObject;
                if (attributeElement == null || attributeElement.isJsonNull() || (jsonObject = attributeElement.getAsJsonObject()) == null || jsonObject.isJsonNull() || (nameElement = jsonObject.get("name")) == null || !nameElement.isJsonPrimitive() || !((JsonPrimitive)nameElement).isString()) continue;
                String attributeName = nameElement.getAsString();
                JsonElement typeE = jsonObject.get("type");
                if (typeE == null || !typeE.isJsonObject() || (typeNameE = typeE.getAsJsonObject().get("name")) == null || !typeNameE.isJsonPrimitive() || !((JsonPrimitive)typeNameE).isString()) continue;
                String typeName = typeNameE.getAsString();
                ICICSAttribute attribute = type.findAttributeByID(attributeName);
                if (attribute == null) continue;
                fieldSet.add(attribute);
                if (attribute.getType() != Long.class || !(metaValue = LongAggregationQueryImpl.getMetaValue((ICICSAttribute<Long>)(longAttribute = attribute))).isPresent() || !"LongAggregationType".equals(typeName)) continue;
                unsupportedMeta.add(longAttribute);
            }
        }
        AggregationMeta meta = new AggregationMeta(){

            @Override
            public boolean supportsAggregation(ICICSAttribute<?> attribute) {
                return fieldSet.contains(attribute);
            }

            @Override
            public boolean schemaSupportsMeta(ICICSAttribute<Long> attribute) {
                return !unsupportedMeta.contains(attribute);
            }
        };
        return Optional.of(new AbstractMap.SimpleEntry<ICICSType, 1>(type, meta));
    }
}

