/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseException;
import com.ibm.cics.sm.comm.sm.internal.graphql.ValueParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class ArrayValueParser<T>
extends ValueParser<List<T>> {
    private ArrayElementParser<T> parser;

    private ArrayValueParser(ArrayElementParser<T> parser) {
        this.parser = parser;
    }

    private static <T> ArrayElementParser<Optional<T>> nullableParser(ValueParser<T> valueParser) {
        return e -> {
            try {
                return valueParser.parse(e);
            }
            catch (ValueParser.ValueParseException ex) {
                throw new NodeParseException("Error parsing array member", ex);
            }
        };
    }

    public static <T> ArrayValueParser<T> nonNullValues(ValueParser<T> valueParser) {
        return new ArrayValueParser<Object>(e -> {
            Optional t = ArrayValueParser.nullableParser(valueParser).parse(e);
            return t.orElseThrow(() -> new NodeParseException("Non null array value was null"));
        });
    }

    public static <T> ArrayValueParser<Optional<T>> nullableValues(ValueParser<T> valueParser) {
        return new ArrayValueParser<Optional<T>>(ArrayValueParser.nullableParser(valueParser));
    }

    @Override
    public List<T> parseValue(JsonElement je) throws NodeParseException, ValueParser.ValueParseException {
        if (je.isJsonArray()) {
            JsonArray array = je.getAsJsonArray();
            ArrayList<T> list = new ArrayList<T>(array.size());
            for (JsonElement jsonElement : array) {
                list.add(this.parser.parse(jsonElement));
            }
            return list;
        }
        throw new NodeParseException("property was not a json array");
    }

    private static interface ArrayElementParser<T> {
        public T parse(JsonElement var1) throws ValueParser.ValueParseException, NodeParseException;
    }
}

