/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.offline;

import com.ibm.cics.model.topology.CICSRegionGroup;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSRegion;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSplex;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OfflineCICSRegionGroup
implements CICSRegionGroup {
    private final Set<String> regions = new HashSet<String>();
    private String name;
    private OfflineCICSplex plex;

    public OfflineCICSRegionGroup(String name, OfflineCICSplex plex) {
        this.name = name;
        this.plex = plex;
    }

    public OfflineCICSplex getCICSplex() {
        return this.plex;
    }

    public OfflineCICSRegion getOrCreateOfflineRegion(String regionName) {
        OfflineCICSRegion region = this.plex.getOrCreateOfflineRegion(regionName);
        this.regions.add(regionName);
        return region;
    }

    public String getName() {
        return this.name;
    }

    public Optional<OfflineCICSRegion> getRegion(String name) {
        return this.regions.contains(name) ? this.plex.getRegion(name) : Optional.empty();
    }

    public Map<String, OfflineCICSRegion> getRegions() {
        return this.regions.stream().collect(Collectors.toMap(Function.identity(), name -> this.plex.getRegion((String)name).get()));
    }
}

