/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.sm.comm.ICICSActionNames;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.sm.internal.VSE61ConnectionBehaviour;

public class VSE62ConnectionBehaviour
extends VSE61ConnectionBehaviour
implements ICICSActionNames {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(VSE62ConnectionBehaviour.class);
    private static final String[] DEFAULT_UNSUPPORTED_ATTRIBUTES = new String[]{"CHANGEUSRID", "CHANGEAGENT", "CHANGEAGREL", "CHANGETIME", "CREATETIME"};
    private static final String[] supportedDefinitions = new String[]{"CONNDEF", "DOCDEF", "FILEDEF", "LSRDEF", "MAPDEF", "PARTDEF", "PROFDEF", "PROGDEF", "PRTNDEF", "SESSDEF", "TCPDEF", "TERMDEF", "TRANDEF", "TRNCLDEF", "TYPTMDEF"};

    public VSE62ConnectionBehaviour() {
        this.setUpSupportedDefinitionsAndUnsupportedAttributes();
    }

    @Override
    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        debug.enter("checkOperation", (Object)this, (Object)resourceType, (Object)context, (Object)operation);
        boolean supported = false;
        switch (operation.getOperationType()) {
            case CREATE: {
                supported = this.isCreateOperationSupportedByVSE(resourceType);
                break;
            }
            default: {
                supported = super.checkOperation(resourceType, context, operation);
            }
        }
        debug.exit("checkOperation", (Object)supported);
        return supported;
    }

    @Override
    public String getActions(String resourceName, IContext context) {
        debug.enter("getActions", (Object)this);
        String actions = String.valueOf(super.getActions(resourceName, context)) + ',' + "create";
        debug.exit("getActions", (Object)actions);
        return actions;
    }

    @Override
    protected void setUpSupportedDeleteResources() {
        super.setUpSupportedDeleteResources();
    }

    @Override
    protected void setUpSupportedOperationsByResource() {
        super.setUpSupportedOperationsByResource();
        this.vseSupportedActionsByResource.put("CSDGROUP", new String[]{"CSDADD", "CSDLOCK", "CSDINSTALL", "CSDUNLOCK"});
        this.vseSupportedActionsByResource.put("CSDLIST", new String[]{"CSDAPPEND", "CSDLOCK", "CSDUNLOCK"});
    }

    protected void setUpSupportedDefinitionsAndUnsupportedAttributes() {
        String[] stringArray = supportedDefinitions;
        int n = supportedDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            String definition = stringArray[n2];
            this.vseSupportedCICSDefinitions.add(definition);
            this.vseSupportedDeleteResources.add(definition);
            if (definition.equals("CONNDEF")) {
                this.vseUnsupportedAttributesByResource.put(definition, this.prefixWithDefaults(new String[]{"XLNACTION"}));
            } else if (definition.equals("DOCDEF")) {
                this.vseUnsupportedAttributesByResource.put(definition, this.prefixWithDefaults(new String[]{"HFSFILE"}));
            } else if (definition.equals("FILEDEF")) {
                this.vseUnsupportedAttributesByResource.put(definition, this.prefixWithDefaults(new String[]{"BACKUPTYPE", "DISPOSITION", "LOADTYPE", "POOLNAME", "READINTEG", "RLSACCESS", "TABLENAME", "UPDATEMODEL"}));
            } else if (definition.equals("LSRDEF")) {
                this.vseUnsupportedAttributesByResource.put(definition, this.prefixWithDefaults(new String[]{"HSDATA4K", "HSDATA8K", "HSDATA12K", "HSDATA16K", "HSDATA20K", "HSDATA24K", "HSDATA28K", "HSDATA32K", "HSINDEX4K", "HSINDEX8K", "HSINDEX12K", "HSINDEX16K", "HSINDEX20K", "HSINDEX24K", "HSINDEX28K", "HSINDEX32K"}));
            } else if (definition.equals("PROGDEF")) {
                this.vseUnsupportedAttributesByResource.put(definition, this.prefixWithDefaults(new String[]{"JVMPROFILE", "JVMSERVER", "JVMCLASS"}));
            } else if (definition.equals("TCPDEF")) {
                this.vseUnsupportedAttributesByResource.put(definition, this.prefixWithDefaults(new String[]{"CIPHERS", "DNSGROUP", "HOST", "REALM", "GRPCRITICAL", "PRIVACY"}));
            } else if (definition.equals("TERMDEF")) {
                this.vseUnsupportedAttributesByResource.put(definition, this.prefixWithDefaults(new String[]{"ASSOCPRNTR", "CONSOLE"}));
            } else if (definition.equals("TRANDEF")) {
                this.vseUnsupportedAttributesByResource.put(definition, this.prefixWithDefaults(new String[]{"FAILACTION", "ISOLATE", "OTSTIMEOUT", "ROUTABLE", "WAIT", "WAITTIMEDD", "WAITTIMEHH", "WAITTIMEMM"}));
            } else if (definition.equals("TYPTMDEF")) {
                this.vseUnsupportedAttributesByResource.put(definition, this.prefixWithDefaults(new String[]{"RSTSIGNOFF"}));
            } else {
                this.vseUnsupportedAttributesByResource.put(definition, DEFAULT_UNSUPPORTED_ATTRIBUTES);
            }
            ++n2;
        }
    }

    public String[] prefixWithDefaults(String[] unsupportedAttributes) {
        String[] prefixed = new String[DEFAULT_UNSUPPORTED_ATTRIBUTES.length + unsupportedAttributes.length];
        System.arraycopy(DEFAULT_UNSUPPORTED_ATTRIBUTES, 0, prefixed, 0, DEFAULT_UNSUPPORTED_ATTRIBUTES.length);
        System.arraycopy(unsupportedAttributes, 0, prefixed, DEFAULT_UNSUPPORTED_ATTRIBUTES.length, unsupportedAttributes.length);
        return prefixed;
    }
}

