/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

import com.ibm.cics.model.CICSDateAttributeAggregation;
import com.ibm.cics.model.CICSEnumAttributeAggregation;
import com.ibm.cics.model.CICSNumericAttributeAggregation;
import com.ibm.cics.model.CICSStringAttributeAggregation;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeAggregation;
import com.ibm.cics.model.ICICSEnum;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CICSObjectAggregateRecord {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Map<ICICSAttribute<?>, ICICSAttributeAggregation> aggregationMap = new HashMap();
    private int countOfAggregatedObjects;

    public CICSObjectAggregateRecord(int countOfAggregatedObjects) {
        this.countOfAggregatedObjects = countOfAggregatedObjects;
    }

    public void addAttributeAggregation(ICICSAttribute<?> attributeName, ICICSAttributeAggregation aggregation) {
        this.aggregationMap.put(attributeName, aggregation);
    }

    public CICSStringAttributeAggregation getStringAggregation(ICICSAttribute<String> attribute) {
        ICICSAttributeAggregation attributeAggregation = this.aggregationMap.get(attribute);
        return attributeAggregation == null ? new CICSStringAttributeAggregation(Optional.empty(), 0, 0) : (CICSStringAttributeAggregation)attributeAggregation;
    }

    public CICSNumericAttributeAggregation getNumericAggregation(ICICSAttribute<Long> attribute) {
        ICICSAttributeAggregation attributeAggregation = this.aggregationMap.get(attribute);
        return attributeAggregation == null ? new CICSNumericAttributeAggregation(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), 0, 0, 0, Optional.empty()) : (CICSNumericAttributeAggregation)attributeAggregation;
    }

    public CICSEnumAttributeAggregation getEnumerationAggregation(ICICSAttribute<? extends ICICSEnum> attribute) {
        ICICSAttributeAggregation attributeAggregation = this.aggregationMap.get(attribute);
        return attributeAggregation == null ? new CICSEnumAttributeAggregation(Collections.emptyList(), 0, 0) : (CICSEnumAttributeAggregation)attributeAggregation;
    }

    public CICSDateAttributeAggregation getDateAggregation(ICICSAttribute<Date> attribute) {
        ICICSAttributeAggregation attributeAggregation = this.aggregationMap.get(attribute);
        return attributeAggregation == null ? new CICSDateAttributeAggregation(Optional.empty(), Optional.empty(), Optional.empty(), 0, 0, 0) : (CICSDateAttributeAggregation)attributeAggregation;
    }

    public int getCountOfAggregatedObjects() {
        return this.countOfAggregatedObjects;
    }

    public String toString() {
        return "CICSObjectAggregateRecord@" + Integer.toHexString(this.hashCode()) + "[" + this.getCountOfAggregatedObjects() + " aggregated records, " + this.aggregationMap.size() + " attributes]";
    }
}

