/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.IFilterVisitor;

public abstract class FilterExpression {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final FilterExpression NULL = new NullExpression();

    public abstract void accept(IFilterVisitor var1);

    public FilterExpression or(FilterExpression expression) {
        return new CompositeExpression(CompositeOperator.OR, this, expression);
    }

    public FilterExpression and(FilterExpression expression) {
        return new CompositeExpression(CompositeOperator.AND, this, expression);
    }

    public static <T> FilterExpression is(ICICSAttribute<T> attribute, T value) {
        return new AttributeExpression(AttributeOperator.IS, attribute, value);
    }

    public static <T> FilterExpression eq(ICICSAttribute<T> attribute, T value) {
        return new AttributeExpression(AttributeOperator.EQ, attribute, value);
    }

    public static <T> FilterExpression lt(ICICSAttribute<T> attribute, T value) {
        return new AttributeExpression(AttributeOperator.LT, attribute, value);
    }

    public static <T> FilterExpression le(ICICSAttribute<T> attribute, T value) {
        return new AttributeExpression(AttributeOperator.LE, attribute, value);
    }

    public static <T> FilterExpression gt(ICICSAttribute<T> attribute, T value) {
        return new AttributeExpression(AttributeOperator.GT, attribute, value);
    }

    public static <T> FilterExpression ge(ICICSAttribute<T> attribute, T value) {
        return new AttributeExpression(AttributeOperator.GE, attribute, value);
    }

    public static <T> FilterExpression ne(ICICSAttribute<T> attribute, T value) {
        return new AttributeExpression(AttributeOperator.NE, attribute, value);
    }

    public static FilterExpression and(FilterExpression op1, FilterExpression op2) {
        return new CompositeExpression(CompositeOperator.AND, op1, op2);
    }

    public static FilterExpression or(FilterExpression op1, FilterExpression op2) {
        return new CompositeExpression(CompositeOperator.OR, op1, op2);
    }

    static FilterExpression not(FilterExpression expression) {
        return new NotExpression(expression);
    }

    private static class AttributeExpression<T>
    extends FilterExpression {
        private final T value;
        private final ICICSAttribute<T> attribute;
        private final AttributeOperator operator;

        private AttributeExpression(AttributeOperator operator, ICICSAttribute<T> attribute, T value) {
            this.operator = operator;
            this.attribute = attribute;
            this.value = value;
        }

        @Override
        public void accept(IFilterVisitor visitor) {
            switch (this.operator) {
                case LT: {
                    visitor.lt(this.attribute, this.value);
                    break;
                }
                case LE: {
                    visitor.le(this.attribute, this.value);
                    break;
                }
                case EQ: {
                    visitor.eq(this.attribute, this.value);
                    break;
                }
                case IS: {
                    visitor.is(this.attribute, this.value);
                    break;
                }
                case GE: {
                    visitor.ge(this.attribute, this.value);
                    break;
                }
                case GT: {
                    visitor.gt(this.attribute, this.value);
                    break;
                }
                case NE: {
                    visitor.ne(this.attribute, this.value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognised operator: " + (Object)((Object)this.operator));
                }
            }
        }
    }

    public static enum AttributeOperator {
        LT,
        LE,
        EQ,
        IS,
        GE,
        GT,
        NE;

    }

    private static class CompositeExpression
    extends FilterExpression {
        private final FilterExpression operand1;
        private final FilterExpression operand2;
        private final CompositeOperator operator;

        private CompositeExpression(CompositeOperator operator, FilterExpression operand1, FilterExpression operand2) {
            this.operator = operator;
            this.operand1 = operand1;
            this.operand2 = operand2;
        }

        @Override
        public void accept(IFilterVisitor visitor) {
            this.operand1.accept(visitor);
            this.operand2.accept(visitor);
            switch (this.operator) {
                case OR: {
                    visitor.or();
                    break;
                }
                case AND: {
                    visitor.and();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)this.operator));
                }
            }
        }
    }

    public static enum CompositeOperator {
        AND,
        OR;

    }

    private static class NotExpression
    extends FilterExpression {
        private final FilterExpression operand;

        private NotExpression(FilterExpression operand) {
            this.operand = operand;
        }

        @Override
        public void accept(IFilterVisitor visitor) {
            this.operand.accept(visitor);
            visitor.not();
        }
    }

    private static class NullExpression
    extends FilterExpression {
        private NullExpression() {
        }

        @Override
        public void accept(IFilterVisitor visitor) {
        }

        @Override
        public FilterExpression and(FilterExpression expression) {
            return expression;
        }

        @Override
        public FilterExpression or(FilterExpression expression) {
            return expression;
        }
    }
}

