/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.flhsupport;

import com.ibm.cics.core.ui.Debug;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ui.internal.views.HelpView;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

class FLHelpSynchronization {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FLHelpSynchronization.class.getPackage().getName());
    public static final String helpViewId = "org.eclipse.help.ui.HelpView";
    public static final String propsViewId = "org.eclipse.ui.views.PropertySheet";
    private boolean enabled = false;
    private IScopeContext[] cachedScopeContexts;
    private SelectionListener propertyTreeSelectionListener;

    public FLHelpSynchronization() {
        if (Debug.DEBUG_SELECTION) {
            Debug.event((Logger)logger, (String)FLHelpSynchronization.class.getName(), (String)"FLHelpSynchronization<init>");
        }
        this.propertyTreeSelectionListener = new PropertyTreeSelectionListener();
        this.addListenerToPropertiesViewIfOpen();
        this.getActiveWorkbenchPage().addPartListener(new IPartListener2(){

            public void partOpened(IWorkbenchPartReference partRef) {
                if (Debug.DEBUG_SELECTION) {
                    Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"partOpened", (Object)partRef);
                }
                if (partRef.getId().equals(FLHelpSynchronization.propsViewId)) {
                    FLHelpSynchronization.this.addPropertyTreeSelectionListenerToPropertiesView((IViewPart)partRef.getPart(false));
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                Tree tree;
                if (Debug.DEBUG_SELECTION) {
                    Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"partClosed", (Object)partRef);
                }
                if (partRef.getId().equals(FLHelpSynchronization.propsViewId) && (tree = FLHelpSynchronization.this.getTree((PropertySheet)partRef.getPart(false))) != null && !tree.isDisposed()) {
                    tree.removeSelectionListener(FLHelpSynchronization.this.propertyTreeSelectionListener);
                }
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        });
    }

    private void addListenerToPropertiesViewIfOpen() {
        IViewPart propsView = this.getActiveWorkbenchPage().findView(propsViewId);
        if (propsView != null) {
            if (Debug.DEBUG_SELECTION) {
                Debug.event((Logger)logger, (String)FLHelpSynchronization.class.getName(), (String)"FLHelpSynchronization<init>", (Object)("found " + propsView));
            }
            this.addPropertyTreeSelectionListenerToPropertiesView(propsView);
        }
    }

    private void addPropertyTreeSelectionListenerToPropertiesView(IViewPart propsView) {
        Tree tree = this.getTree((PropertySheet)propsView);
        if (tree != null && !tree.isDisposed()) {
            if (Debug.DEBUG_SELECTION) {
                Debug.event((Logger)logger, (String)FLHelpSynchronization.class.getName(), (String)"addPropertyTreeSelectionListenerToPropertiesView", (Object)this.propertyTreeSelectionListener);
            }
            tree.addSelectionListener(this.propertyTreeSelectionListener);
        }
    }

    public void setEnabled(boolean newState) {
        if (Debug.DEBUG_SELECTION) {
            Debug.event((Logger)logger, (String)FLHelpSynchronization.class.getName(), (String)"setEnabled", (Object)newState);
        }
        this.enabled = newState;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private Tree getTree(PropertySheet view) {
        if (view != null) {
            PropertySheetPage psp = null;
            psp = (PropertySheetPage)view.getDefaultPage();
            if (psp != null) {
                Tree tree = (Tree)psp.getControl();
                return tree;
            }
        }
        return null;
    }

    private void requestDisplayHelpForTreeItem(TreeItem ti) {
        Object data = ti.getData();
        if (data instanceof PropertySheetEntry) {
            PropertySheetEntry pse = (PropertySheetEntry)data;
            Object helpContextId = pse.getHelpContextIds();
            this.requestWorkbenchHelpSystemDisplayHelp(helpContextId);
        }
    }

    public void requestWorkbenchHelpSystemDisplayHelp(final Object helpContextId) {
        if (this.enabled && helpContextId instanceof String && ((String)helpContextId).startsWith("com.ibm.cics.core.ui")) {
            IViewPart helpView;
            if (Debug.DEBUG_SELECTION) {
                Debug.event((Logger)logger, (String)FLHelpSynchronization.class.getName(), (String)"requestWorkbenchHelpSystemDisplayHelp", (Object)helpContextId);
            }
            if ((helpView = this.findHelpViewIfVisibleAndUsable()) != null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IHelpResource[] topics;
                        IContext context = HelpSystem.getContext((String)((String)helpContextId));
                        if (context != null && (topics = context.getRelatedTopics()) != null && topics.length > 0) {
                            ((HelpView)helpView).showHelp(topics[0].getHref());
                        }
                    }
                });
            }
        }
    }

    private IViewPart findHelpViewIfVisibleAndUsable() {
        boolean winfopop;
        IWorkbenchPage activePage = this.getActiveWorkbenchPage();
        IViewPart helpView = activePage.findView(helpViewId);
        IViewPart result = null;
        if (helpView != null && this.getActiveWorkbenchPage().isPartVisible((IWorkbenchPart)helpView) && !(winfopop = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "window_infopop", false, this.getPreferenceScopeToSearchForHelpInfopopOption()))) {
            result = helpView;
        }
        if (Debug.DEBUG_SELECTION) {
            Debug.event((Logger)logger, (String)FLHelpSynchronization.class.getName(), (String)"findHelpViewIfVisibleAndUsable", result);
        }
        return result;
    }

    private IScopeContext[] getPreferenceScopeToSearchForHelpInfopopOption() {
        if (this.cachedScopeContexts == null) {
            this.cachedScopeContexts = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        }
        return this.cachedScopeContexts;
    }

    private IWorkbenchPage getActiveWorkbenchPage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private class PropertyTreeSelectionListener
    implements SelectionListener {
        private PropertyTreeSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (Debug.DEBUG_SELECTION) {
                Debug.event((Logger)logger, (String)PropertyTreeSelectionListener.class.getName(), (String)"widgetSelected", (Object)e);
            }
            if (!FLHelpSynchronization.this.enabled) {
                return;
            }
            TreeItem ti = (TreeItem)e.item;
            FLHelpSynchronization.this.requestDisplayHelpForTreeItem(ti);
        }
    }
}

