/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CICSStringAttribute;
import com.ibm.cics.core.model.Messages;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.osgi.util.NLS;

public class StartupDateAttribute
extends CICSStringAttribute {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public StartupDateAttribute(String propertyId, String categoryId, String cicsName, String defaultValue, CICSRelease cicsRelease, CICSRelease cicsRelease2) {
        super(propertyId, categoryId, cicsName, defaultValue, cicsRelease, cicsRelease2);
    }

    @Override
    protected String internalToExternalImpl(String modelValue) throws IllegalCICSAttributeException {
        try {
            Date modelValueAsDate = new SimpleDateFormat("yyyy-MM-dd").parse(modelValue);
            try {
                return new SimpleDateFormat("yyyy/DDD").format(modelValueAsDate);
            }
            catch (Exception e) {
                throw new IllegalCICSAttributeException(NLS.bind((String)Messages.CICSDateAttribute_invalidDate, (Object[])new Object[]{modelValueAsDate, "yyyy/DDD"}), (ICICSAttribute)this, (Object)modelValueAsDate);
            }
        }
        catch (ParseException e) {
            throw new IllegalCICSAttributeException(NLS.bind((String)Messages.CICSDateAttribute_invalidDate, (Object[])new Object[]{modelValue, "yyyy-MM-dd"}), (ICICSAttribute)this, (Object)modelValue);
        }
    }
}

