/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.PhysicalDataSetReference;
import com.ibm.cics.core.model.PhysicalDataSetType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IPhysicalDataSet;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutablePhysicalDataSet;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutablePhysicalDataSet
extends MutableCICSResource
implements IMutablePhysicalDataSet {
    private IPhysicalDataSet delegate;
    private MutableSMRecord record;

    public MutablePhysicalDataSet(ICPSM cpsm, IContext context, IPhysicalDataSet cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("DSNAME");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getDsname() {
        return this.delegate.getDsname();
    }

    public IPhysicalDataSet.AccessMethodValue getAccessMethod() {
        return this.delegate.getAccessMethod();
    }

    public IPhysicalDataSet.BackUpTypeValue getBackUpType() {
        return this.delegate.getBackUpType();
    }

    public String getBaseDSName() {
        return this.delegate.getBaseDSName();
    }

    public Long getFileCount() {
        return this.delegate.getFileCount();
    }

    public IPhysicalDataSet.DataSetTypeValue getDataSetType() {
        return this.delegate.getDataSetType();
    }

    public IPhysicalDataSet.RecoveryStatusValue getRecoveryStatus() {
        return this.delegate.getRecoveryStatus();
    }

    public IPhysicalDataSet.DataSetValidityValue getDataSetValidity() {
        return this.delegate.getDataSetValidity();
    }

    public Long getJournalNumber() {
        return this.delegate.getJournalNumber();
    }

    public String getLogStreamName() {
        return this.delegate.getLogStreamName();
    }

    public IPhysicalDataSet.AvailabilityValue getAvailability() {
        String result = this.record.get("AVAILABILITY");
        if (result == null) {
            return this.delegate.getAvailability();
        }
        return (IPhysicalDataSet.AvailabilityValue)((CICSAttribute)PhysicalDataSetType.AVAILABILITY).get(result, this.record.getNormalizers());
    }

    public IPhysicalDataSet.LostLocksValue getLostLocks() {
        return this.delegate.getLostLocks();
    }

    public IPhysicalDataSet.QuiesceStateValue getQuiesceState() {
        String result = this.record.get("QUIESCESTATE");
        if (result == null) {
            return this.delegate.getQuiesceState();
        }
        return (IPhysicalDataSet.QuiesceStateValue)((CICSAttribute)PhysicalDataSetType.QUIESCE_STATE).get(result, this.record.getNormalizers());
    }

    public IPhysicalDataSet.RetainedRecordLocksValue getRetainedRecordLocks() {
        return this.delegate.getRetainedRecordLocks();
    }

    public IPhysicalDataSet.ReplicationLoggingStatusValue getReplicationLoggingStatus() {
        return this.delegate.getReplicationLoggingStatus();
    }

    public void setAvailability(IPhysicalDataSet.AvailabilityValue _availability) {
        if (_availability.equals((Object)this.delegate.getAvailability())) {
            this.record.set("AVAILABILITY", null);
        } else {
            PhysicalDataSetType.AVAILABILITY.validate((Object)_availability);
            String connectionSpecificExternalValue = ((CICSAttribute)PhysicalDataSetType.AVAILABILITY).set(_availability, this.record.getNormalizers());
            this.record.set("AVAILABILITY", connectionSpecificExternalValue);
        }
    }

    public void setQuiesceState(IPhysicalDataSet.QuiesceStateValue _quiesceState) {
        if (_quiesceState.equals((Object)this.delegate.getQuiesceState())) {
            this.record.set("QUIESCESTATE", null);
        } else {
            PhysicalDataSetType.QUIESCE_STATE.validate((Object)_quiesceState);
            String connectionSpecificExternalValue = ((CICSAttribute)PhysicalDataSetType.QUIESCE_STATE).set(_quiesceState, this.record.getNormalizers());
            this.record.set("QUIESCESTATE", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == PhysicalDataSetType.DSNAME) {
            return (V)this.getDsname();
        }
        if (attribute == PhysicalDataSetType.ACCESS_METHOD) {
            return (V)this.getAccessMethod();
        }
        if (attribute == PhysicalDataSetType.BACK_UP_TYPE) {
            return (V)this.getBackUpType();
        }
        if (attribute == PhysicalDataSetType.BASE_DS_NAME) {
            return (V)this.getBaseDSName();
        }
        if (attribute == PhysicalDataSetType.FILE_COUNT) {
            return (V)this.getFileCount();
        }
        if (attribute == PhysicalDataSetType.DATA_SET_TYPE) {
            return (V)this.getDataSetType();
        }
        if (attribute == PhysicalDataSetType.RECOVERY_STATUS) {
            return (V)this.getRecoveryStatus();
        }
        if (attribute == PhysicalDataSetType.DATA_SET_VALIDITY) {
            return (V)this.getDataSetValidity();
        }
        if (attribute == PhysicalDataSetType.JOURNAL_NUMBER) {
            return (V)this.getJournalNumber();
        }
        if (attribute == PhysicalDataSetType.LOG_STREAM_NAME) {
            return (V)this.getLogStreamName();
        }
        if (attribute == PhysicalDataSetType.AVAILABILITY) {
            return (V)this.getAvailability();
        }
        if (attribute == PhysicalDataSetType.LOST_LOCKS) {
            return (V)this.getLostLocks();
        }
        if (attribute == PhysicalDataSetType.QUIESCE_STATE) {
            return (V)this.getQuiesceState();
        }
        if (attribute == PhysicalDataSetType.RETAINED_RECORD_LOCKS) {
            return (V)this.getRetainedRecordLocks();
        }
        if (attribute == PhysicalDataSetType.REPLICATION_LOGGING_STATUS) {
            return (V)this.getReplicationLoggingStatus();
        }
        return super.getAttributeValue(attribute);
    }

    public PhysicalDataSetType getObjectType() {
        return PhysicalDataSetType.getInstance();
    }

    @Override
    public PhysicalDataSetReference getCICSObjectReference() {
        return new PhysicalDataSetReference(this.getCICSContainer(), this.getDsname());
    }
}

