/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.model.CICSRegionDefinitionType;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CPSM;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.model.CICSRegionDefinitionInstallTarget;
import com.ibm.cics.model.CICSRegionGroupDefinitionInstallTarget;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import org.eclipse.core.runtime.IAdapterFactory;

public class InstallTargetToCICSObjectAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(InstallTargetToCICSObjectAdapterFactory.class);

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof CICSRegionGroupDefinitionInstallTarget) {
            try {
                CICSRegionGroupDefinitionInstallTarget target = (CICSRegionGroupDefinitionInstallTarget)adaptableObject;
                CPSM cpsm = (CPSM)ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection");
                Context context = new Context(target.getContextString());
                IPrimaryKey primaryKey = CICSRegionGroupDefinitionType.getPrimaryKey((IContext)context, (String)target.getID());
                ICICSObject[] definitions = cpsm.getDefinitions2((ICICSType)CICSRegionGroupDefinitionType.getInstance(), (IContext)primaryKey);
                if (definitions.length == 1) {
                    return definitions[0];
                }
            }
            catch (CICSSystemManagerException e) {
                debug.error("getAdapterGroup", (Throwable)e);
            }
        } else if (adaptableObject instanceof CICSRegionDefinitionInstallTarget) {
            try {
                CICSRegionDefinitionInstallTarget target = (CICSRegionDefinitionInstallTarget)adaptableObject;
                CPSM cpsm = (CPSM)ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection");
                Context context = new Context(target.getContextString());
                IPrimaryKey primaryKey = CICSRegionDefinitionType.getPrimaryKey((IContext)context, (String)target.getID());
                ICICSObject[] definitions = cpsm.getDefinitions2((ICICSType)CICSRegionDefinitionType.getInstance(), (IContext)primaryKey);
                if (definitions.length == 1) {
                    return definitions[0];
                }
            }
            catch (CICSSystemManagerException e) {
                debug.error("getAdapterRegion", (Throwable)e);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{ICICSRegionDefinition.class, ICICSRegionGroupDefinition.class};
    }
}

